/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class UpdateRepositoryProfilesJobNode
extends SimpleJobNode
implements ProgressJobNode {
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private String eprParam = "repoEpr";
    private String existingReposParam = "existingRepos";
    private ResultsetProgressProvider progressProvider;
    private static final Log log = LogFactory.getLog(UpdateRepositoryProfilesJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        Map existingRepos = (Map)token.getFullEnv().getTransientAttribute(this.getExistingReposParam());
        W3CEndpointReference epr = (W3CEndpointReference)token.getFullEnv().getTransientAttribute(this.getEprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        SAXReader reader = new SAXReader();
        int countUpdated = 0;
        int countInserted = 0;
        int countProfileErrors = 0;
        log.info((Object)"Adding/updating repository profiles...");
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        for (String profile : this.resultSetClientFactory.getClient(this.progressProvider.getEpr())) {
            try {
                String profId;
                Document doc = reader.read((Reader)new StringReader(profile));
                String dsId = doc.valueOf("//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value");
                log.debug((Object)("Registering/updating profile:\n " + profile + "\n"));
                if (existingRepos.containsKey(dsId)) {
                    profId = (String)existingRepos.get(dsId);
                    doc.selectSingleNode("//RESOURCE_IDENTIFIER/@value").setText(profId);
                    registry.updateProfile(profId, doc.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
                    log.debug((Object)("Profile " + profId + " UPDATED for ds " + dsId));
                    ++countUpdated;
                    continue;
                }
                profId = registry.registerProfile(doc.asXML());
                log.debug((Object)("Valid Profile " + profId + " REGISTERED for ds " + dsId));
                ++countInserted;
            }
            catch (Exception e) {
                log.error((Object)("INVALID PROFILE: " + profile), (Throwable)e);
                ++countProfileErrors;
            }
        }
        log.info((Object)("   - updated_profiles: " + countUpdated));
        log.info((Object)("   - inserted_profiles: " + countInserted));
        log.info((Object)("   - profiles_with_errors: " + countProfileErrors));
        token.getEnv().setAttribute("mainlog:updated_profiles", (Object)countUpdated);
        token.getEnv().setAttribute("mainlog:inserted_profiles", (Object)countInserted);
        token.getEnv().setAttribute("mainlog:profiles_with_errors", (Object)countProfileErrors);
        return Arc.DEFAULT_ARC;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getExistingReposParam() {
        return this.existingReposParam;
    }

    public void setExistingReposParam(String existingReposParam) {
        this.existingReposParam = existingReposParam;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }
}

