/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.ContextDesc;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.ContextPart;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ContextUtils {
    private static final Log log = LogFactory.getLog(ContextUtils.class);

    public static ContextDesc getContext(Iterable<String> it, String contextId, String contextLabel, String contextType) throws DocumentException {
        return new ContextUtils().getContextDesc(it, contextId, contextLabel, contextType);
    }

    private ContextDesc getContextDesc(Iterable<String> it, String contextId, String contextLabel, String contextType) throws DocumentException {
        ContextDesc context = new ContextDesc(contextId, contextLabel, contextType);
        SAXReader reader = new SAXReader();
        for (String s : it) {
            this.populateContext(context, reader, s);
        }
        return context;
    }

    private void populateContext(ContextDesc context, SAXReader reader, String s) throws DocumentException {
        Document doc = reader.read((Reader)new StringReader(s));
        for (Object o : doc.selectNodes("//fundingtree")) {
            Element treeNode = (Element)o;
            String funder = treeNode.valueOf("./funder/id");
            if (StringUtils.isBlank((String)funder)) {
                log.debug((Object)("No funder found, skipping population from the following XML: " + s));
                return;
            }
            if (!context.getDbEntries().containsKey(funder)) {
                log.info((Object)("Found funder: " + funder));
                context.getDbEntries().put(funder, treeNode.selectSingleNode("./funder").asXML());
                log.debug((Object)("db entry: " + context.getDbEntries().get(funder)));
            }
            String openaireId = treeNode.valueOf("./*[starts-with(local-name(),'funding_level_')]/id");
            if (context.getDbEntries().containsKey(openaireId) || !StringUtils.isNotBlank((String)openaireId)) continue;
            log.info((Object)("Found funding: " + openaireId));
            context.getDbEntries().put(openaireId, treeNode.asXML());
            log.debug((Object)("db entry: " + context.getDbEntries().get(openaireId)));
            Node node0 = treeNode.selectSingleNode(".//funding_level_0");
            if (node0 == null) continue;
            ContextPart part = this.calculatePart(node0);
            if (context.getCategories().containsKey(part.getId())) {
                for (ContextPart p : part.getParts().values()) {
                    context.getCategories().get(part.getId()).addPart(p);
                }
                continue;
            }
            context.getCategories().put(part.getId(), part);
        }
    }

    private ContextPart calculatePart(Node node) {
        Element parent;
        String newId = StringUtils.substringAfter((String)node.valueOf("./id"), (String)"::");
        ContextPart part = new ContextPart(newId, node.valueOf("./description"));
        part.getParams().put("name", node.valueOf("./name"));
        part.getParams().put("openaireId", node.valueOf("./id"));
        part.getParams().put("class", node.valueOf("./class"));
        Element element = parent = node.getParent() != null ? node.getParent().getParent() : null;
        if (parent != null && parent.getName().startsWith("funding_level_")) {
            ContextPart p = this.calculatePart((Node)parent);
            part.getParts().put(p.getId(), p);
        }
        return part;
    }

    public static Function<Map.Entry<String, String>, String> getContextRowTransformer() {
        return new Function<Map.Entry<String, String>, String>(){
            private final SAXReader reader = new SAXReader();

            public String apply(Map.Entry<String, String> e) {
                try {
                    Map<String, String> orgFields;
                    String orgId;
                    Document docFundingPath = this.reader.read((Reader)new StringReader(e.getValue()));
                    Element root = DocumentHelper.createElement((String)"ROWS");
                    LinkedHashMap fundingFields = Maps.newLinkedHashMap();
                    fundingFields.put("_dnet_resource_identifier_", e.getKey());
                    fundingFields.put("id", e.getKey());
                    fundingFields.put("path", e.getValue());
                    fundingFields.put("jurisdiction", docFundingPath.valueOf("//funder/jurisdiction"));
                    String desc = docFundingPath.valueOf("(//*[starts-with(local-name(),'funding_level_')])[1]/description");
                    if (StringUtils.isNotBlank((String)desc)) {
                        fundingFields.put("description", desc);
                    }
                    if (StringUtils.isNotBlank((String)(orgId = (orgFields = this.findFunderInfo(docFundingPath)).get("id")))) {
                        this.addRow(root, "organizations", orgFields);
                        fundingFields.put("funder", orgId);
                    }
                    this.addRow(root, "fundingpaths", fundingFields);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Db entries: " + root.asXML()));
                    }
                    return root.asXML();
                }
                catch (DocumentException e1) {
                    log.error((Object)"Error parsing xml", (Throwable)e1);
                    throw new RuntimeException("Error parsing xml", e1);
                }
            }

            private Map<String, String> findFunderInfo(Document doc) {
                LinkedHashMap res = Maps.newLinkedHashMap();
                res.put("_dnet_resource_identifier_", doc.valueOf("//funder/id"));
                res.put("id", doc.valueOf("//funder/id"));
                res.put("legalshortname", doc.valueOf("//funder/shortname"));
                res.put("legalname", doc.valueOf("//funder/name"));
                return res;
            }

            private void addRow(Element root, String table, Map<String, String> fields) {
                Element row = root.addElement("ROW");
                row.addAttribute("table", table);
                for (Map.Entry<String, String> e : fields.entrySet()) {
                    Element pathField = row.addElement("FIELD");
                    pathField.addAttribute("name", e.getKey());
                    pathField.setText(e.getValue());
                }
            }
        };
    }
}

