<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:fn="http://www.w3.org/2005/xpath-functions">

	<xsl:param name="parentDatasourceId" />
	<xsl:param name="namespacePrefix" />

	<xsl:variable name="funderID" select="concat($namespacePrefix, '::NIH')" />
	<xsl:variable name="fundingName" select="upper-case(normalize-space(//IC_NAME))"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="$fundingName != ''">
				<xsl:value-of select="concat($funderID, '::', translate($fundingName,' ','_'))"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', .//FULL_PROJECT_NUM)" />
	<xsl:variable name="orgID" select="concat($namespacePrefix, '::', upper-case(translate(.//ORG_NAME, ' ,', '__')))" />

	<xsl:variable name="terms" select="string-join(.//PROJECT_TERMS/TERM/text(), ',')"/>
	<xsl:variable name="termsx" select="string-join(.//PROJECT_TERMSX/TERM/text(), ',')"/>

	<xsl:template match="/">
    	<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

		<xsl:copy-of select=".//*[local-name()='header']"/>
		<metadata>
		<ROWS>
			<xsl:if test="string-length(normalize-space(.//PROJECT_TITLE)) &gt; 0 and string-length($projectID) &gt; 0">

				<xsl:variable name="startDate" select=".//PROJECT_START"/>
				<xsl:variable name="endDate" select=".//PROJECT_END"/>

				<ROW table="projects">
					<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="id"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="code"><xsl:value-of select=".//FULL_PROJECT_NUM"/></FIELD>
					<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
					<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
					<FIELD name="title"><xsl:value-of select=".//PROJECT_TITLE" /></FIELD>
					<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
					<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
					<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
					<FIELD name="optional1"><xsl:value-of select="concat(.//TOTAL_COST, ' $')" /></FIELD>
				</ROW>
				<ROW table="project_fundingpath">
					<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingID,'@@', $projectID)" /></FIELD>
					<FIELD name="funding"><xsl:value-of select="$fundingID" /></FIELD>
					<FIELD name="project"><xsl:value-of select="$projectID" /></FIELD>
					<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
					<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
				</ROW>

				<!--
				<xsl:for-each select=".//PIS/PI[./PI_ID != '']">
					<xsl:variable name="personId" select="concat($namespacePrefix, '::', ./PI_ID)"/>
					<xsl:variable name="personName" select="tokenize(./PI_NAME, ',')"/>
					<ROW table="persons">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$personID" /></FIELD>
						<FIELD name="id"><xsl:value-of select="$personID" /></FIELD>
						<FIELD name="firstname"><xsl:value-of select="$personName[1]" /></FIELD>
						<FIELD name="secondnames"><xsl:value-of select="$personName[0]" /></FIELD>
						<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
					</ROW>
				</xsl:for-each>
				-->

				<xsl:if test="string-length($orgID) &gt; 4"> 
					<ROW table="organizations">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$orgID" /></FIELD>
						<FIELD name="id"><xsl:value-of select="$orgID" /></FIELD>
						<FIELD name="legalname"><xsl:value-of select=".//ORG_NAME" /></FIELD>
						<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						<FIELD name="trust" type="float">0.8</FIELD>
					</ROW>
					<ROW table="project_organization">
						<!--<xsl:variable name="contactPerson" select=".//PIS/PI[./PI_ID != ''][1]"/> -->
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($projectID, '@@', $orgID)" /></FIELD>
						<FIELD name="participantnumber" type="int">1</FIELD>
						<FIELD name="startdate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$startDate" /></FIELD>
						<FIELD name="enddate" type="date" format="MM/dd/yyyy"><xsl:value-of select="$endDate" /></FIELD>
						<FIELD name="project"><xsl:value-of select="$projectID" /></FIELD>
						<FIELD name="resporganization"><xsl:value-of select="$orgID" /></FIELD>
						<!--
						<xsl:if test="$contactPerson">
							<FIELD name="contactperson"><xsl:value-of select="concat($namespacePrefix, '::', $contactPerson/PI_ID)" /></FIELD>
						</xsl:if>
						-->
						<FIELD name="semanticclass">participant</FIELD>
						<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
					</ROW>
				</xsl:if>

			</xsl:if>
		</ROWS>
		</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
