/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api;

import com.google.gson.Gson;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.api.RecentPublicationsQueue;
import eu.dnetlib.msro.openaireplus.api.objects.PublicationEntry;
import eu.dnetlib.msro.openaireplus.utils.OafToIndexRecordFactory;
import eu.dnetlib.msro.rmi.MSROException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class SinglePublicationSubmitter {
    private static final Log log = LogFactory.getLog(SinglePublicationSubmitter.class);
    @Value(value="oaf.schema.location")
    private String oafSchemaLocation;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private RecentPublicationsQueue recentPublicationsQueue;
    @Resource(name="openaireplusApisVelocityEngine")
    private VelocityEngine velocityEngine;
    @Value(value="${openaireplus.msro.api.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaireplus.msro.api.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;

    @RequestMapping(value={"/api/publications/feedJson"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addPublication(@RequestParam(value="json", required=true) String json) throws MSROException {
        PublicationEntry pub = (PublicationEntry)new Gson().fromJson(json, PublicationEntry.class);
        return this.addPublication(pub);
    }

    @RequestMapping(value={"/api/publications/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addPublication(@RequestBody PublicationEntry pub) throws MSROException {
        if (StringUtils.isBlank((String)pub.getOriginalId())) {
            throw new MSROException("A required field is missing: originalId");
        }
        if (StringUtils.isBlank((String)pub.getTitle())) {
            throw new MSROException("A required field is missing: title");
        }
        if (StringUtils.isBlank((String)pub.getUrl())) {
            throw new MSROException("A required field is missing: url");
        }
        if (StringUtils.isBlank((String)pub.getLicenseCode())) {
            throw new MSROException("A required field is missing: licenceCode");
        }
        if (StringUtils.isBlank((String)pub.getResourceType())) {
            throw new MSROException("A required field is missing: resourceType");
        }
        if (StringUtils.isBlank((String)pub.getCollectedFromId())) {
            throw new MSROException("A required field is missing: collectedFromId");
        }
        if (StringUtils.isBlank((String)pub.getType())) {
            throw new MSROException("A required field is missing: type");
        }
        try (CloudIndexClient idxClient = null;){
            IndexDsInfo idx = this.calculateCurrentIndexDsInfo();
            idxClient = CloudIndexClientFactory.newIndexClient((String)idx.getIndexBaseUrl(), (String)idx.getColl(), (boolean)false);
            String oafRecord = pub.asOafRecord(this.velocityEngine, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class), this.oafSchemaLocation);
            this.recentPublicationsQueue.add(oafRecord);
            boolean bl = idxClient.feed(oafRecord, idx.getIndexDsId(), (UnaryFunction)this.oafToIndexRecordFactory.newTransformer(idx.getFormat())) == 0;
            return bl;
        }
    }

    @RequestMapping(value={"/api/publications/deleteObject"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean deletePublication(@RequestParam(value="originalId", required=true) String originalId, @RequestParam(value="collectedFromId", required=true) String collectedFromId) throws MSROException {
        try (Object idxClient = null;){
            IndexDsInfo idx = this.calculateCurrentIndexDsInfo();
            String objId = PublicationEntry.calculateObjId(originalId, collectedFromId, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class));
            CloudIndexClientFactory.newIndexClient((String)idx.getIndexBaseUrl(), (String)idx.getColl(), (boolean)false).remove(objId);
            this.recentPublicationsQueue.remove(objId);
            boolean bl = true;
            return bl;
        }
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(Exception e) {
        log.error((Object)"Error in direct index API", (Throwable)e);
        return new ErrorMessage(e);
    }

    private IndexDsInfo calculateCurrentIndexDsInfo() throws Exception {
        String queryUrl = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        String queryDs = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        ISLookUpService lu = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String indexBaseUrl = lu.getResourceProfileByQuery(queryUrl);
        String[] arr = lu.getResourceProfileByQuery(queryDs).split("@@@");
        return new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim());
    }

    public class ErrorMessage {
        private final String message;
        private final String stacktrace;

        public ErrorMessage(Exception e) {
            this(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }

        public ErrorMessage(String message, String stacktrace) {
            this.message = message;
            this.stacktrace = stacktrace;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStacktrace() {
            return this.stacktrace;
        }
    }

    public class IndexDsInfo {
        private final String indexBaseUrl;
        private final String indexDsId;
        private final String format;
        private final String coll;

        public IndexDsInfo(String indexBaseUrl, String indexDsId, String format, String coll) {
            this.indexBaseUrl = indexBaseUrl;
            this.indexDsId = indexDsId;
            this.format = format;
            this.coll = coll;
        }

        public String getIndexBaseUrl() {
            return this.indexBaseUrl;
        }

        public String getIndexDsId() {
            return this.indexDsId;
        }

        public String getFormat() {
            return this.format;
        }

        public String getColl() {
            return this.coll;
        }
    }
}

