CREATE TABLE IF NOT EXISTS hostedby_map (
	_dnet_resource_identifier_ character varying(2048) DEFAULT 'temp_'||md5(clock_timestamp()::text)||'_'||md5(random()::text),
	oa_source_id               character varying(255) references  datasources(id),
	entry                      character varying(255) NOT NULL,
	datasourceid               character varying(255) references datasources(id),
  PRIMARY key(oa_source_id, entry)
);

--DATACITE API
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES ('api_________::datacite::oaisets', 'api_________::datacite::oaisets', 'oai_sets', 'openaire____::datacite', 'aggregator::datarepository', 'native');
INSERT INTO apicollections (param, original, api) VALUES ('baseUrl', 'http://oai.datacite.org/oai', 'api_________::datacite::oaisets');
INSERT INTO apicollections (param, original, api, accessparam) VALUES ('metadata_identifier_path', '//*[local-name() = ''setSpec'']', 'api_________::datacite::oaisets', false);

--PANGAEA BY PROJECT
INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES  ('api_________::re3data_____::r3d100010134::pangaeabyproject', 'api_________::re3data_____::r3d100010134::pangaeabyproject', 'datasetsbyproject',  're3data_____::r3d100010134', 'datarepository::unknown', 'native');
insert into apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'metadata_identifier_path' ,'//*[local-name()=''header'']/*[local-name()=''identifier'']', 'api_________::re3data_____::r3d100010134::pangaeabyproject', 'api_________::re3data_____::r3d100010134::pangaeabyproject@@metadata_identifier_path', false);
insert into apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'baseUrl', 'file:///var/lib/dnet/pangaea_projects.csv', 'api_________::re3data_____::r3d100010134::pangaeabyproject', 'api_________::re3data_____::r3d100010134::pangaeabyproject@@baseUrl', true);


--PANGAEA BY JOURNAL

INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES ('api_________::re3data_____::r3d100010134::pangaeabyjournal', 'api_________::re3data_____::r3d100010134::pangaeabyjournal',  'datasetsbyjournal',  're3data_____::r3d100010134', 'datarepository::unknown', 'native');
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'metadata_identifier_path' ,'//*[local-name()=''header'']/*[local-name()=''identifier'']', 'api_________::re3data_____::r3d100010134::pangaeabyjournal',  'api_________::re3data_____::r3d100010134::pangaeabyjournal@@metadata_identifier_path', false);

INSERT INTO api (_dnet_resource_identifier_, id, protocolclass, datasource, typologyclass, compatibilityclass) VALUES ('api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'fileCSV',  're3data_____::r3d100010134', 'datarepository::unknown', 'native');
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'metadata_identifier_path' ,'//*[local-name()=''column'' and @isID=''true'']', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@metadata_identifier_path', false);
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'baseUrl' ,'file:///var/lib/dnet/pangaea_journals.csv', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@baseUrl', true);
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)   values ( 'quote' ,'"', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@quote', true);       
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'header' ,'true', 'api_________::re3data_____::r3d100010134::pangaeabyjournalCSV','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@header', true); 
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'identifier' ,'4','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@identifier', true); 
INSERT INTO apicollections(param,original,api, _dnet_resource_identifier_, accessparam)  values ( 'separator' ,'@','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV','api_________::re3data_____::r3d100010134::pangaeabyjournalCSV@@separator', true);

--DOAJ

insert into api (id, _dnet_resource_identifier_ , protocolclass, datasource , contentdescriptionclass, typologyclass, compatibilityclass) values ('api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV' , 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV', 'httpCSV', 'driver______::1790119e-d281-4b7a-aedf-866d1d853a07', 'metadata',	 'entityregistry' , 'native');

insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('baseUrl', 'http://doaj.org/csv', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV','api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@baseUrl',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('separator', ',', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV','api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@separator',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('quote', '"', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV','api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@quote',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('identifier', 'ISSN', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV','api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@identifier',true);
insert into apicollections(param,original,api,_dnet_resource_identifier_,accessparam) values('metadata_identifier_path', '//column[./@isID=''true'']', 'api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV','api_________::driver______::1790119e-d281-4b7a-aedf-866d1d853a07::httpCSV@@metadata_identifier_path',false);
     
     
     
CREATE TABLE IF NOT EXISTS hostedby_props (
	_dnet_resource_identifier_ character varying(2048) NOT NULL references hostedby_map(_dnet_resource_identifier_),
	key               character varying(255) NOT NULL,
	value                      character varying(255) NOT NULL,	
  PRIMARY key(_dnet_resource_identifier_, key,value)
);