<NODE name="SET_INFO_VALIDATION" isStart="true" type="SetInfoForValidation">
	<DESCRIPTION>Retrieve information about current Content Provider</DESCRIPTION>
	<PARAMETERS>
        <PARAM required="true" type="string" name="profileId" managedBy="system">$params.("dataprovider:id")$</PARAM>
        <PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
        <PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
    </PARAMETERS>
	<ARCS>
		<ARC to="obtainParams"/>
	</ARCS>
</NODE>
<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Get more datasource info</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="selectValidate"/>
	</ARCS>
</NODE>
<NODE name="selectValidate" type="Selection">
	<DESCRIPTION>Do we validate the records?</DESCRIPTION>
	<PARAMETERS>
		<PARAM function="validValues(['YES', 'NO'])" managedBy="user" name="selection" required="true" type="string">YES</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC name="YES" to="validate" />
		<ARC name="NO" to="success" />
	</ARCS>
</NODE>
<NODE name="validate" type="ValidationAsStep">
	<DESCRIPTION>Validate from mdStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="boolean" name="shouldOutputRecords" managedBy="system">false</PARAM>
		<PARAM required="false" type="string" name="outputEprName" managedBy="system">validatorEpr</PARAM>
		<PARAM required="true" type="string" name="mdstoreId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="xQueryForValidatorServiceId" managedBy="user">/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='ValidatorServiceResourceType' and .//RESOURCE_KIND/@value='ServiceResources']/HEADER/RESOURCE_IDENTIFIER/@value/string()</PARAM>	
	    <PARAM required="false" type="string" name="recordsSampleSize" managedBy="user">ALL</PARAM>
	    <PARAM required="true" type="string" name="guidelines" managedBy="user" function="validValues(['openaire3.0', 'openaire2.0', 'openaire2.0_data', 'driver'])">$params.("dataprovider:interface:compliance")$</PARAM>
	    <PARAM required="true" type="boolean" name="shouldUpdateBlacklist" managedBy="user">true</PARAM>
		<PARAM required="false" type="string" name="blacklistRuleName" managedBy="user">blacklist_rules</PARAM>
		<PARAM required="false" type="int" name="jobStatusUpdateInterval" managedBy="system"/>
	    <PARAM required="false" type="string" name="extraParams" managedBy="user"/>  
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
