package eu.dnetlib.msro.openaireplus.workflows.nodes.datacite;

import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

/**
 * The Class SplitDatasetRecord.
 */
public class SplitDatasetRecord extends SimpleJobNode {

	/** The input epr parm. */
	private String inputEprParm;

	/** The output epr parm. */
	private String outputEprParm;

	/** The result set client factory. */
	private ResultSetClientFactory resultSetClientFactory;

	/** The result set factory. */
	@Resource(name = "iterableResultSetFactory")
	private IterableResultSetFactory resultSetFactory;

	/** The executor. */
	private Executor executor = Executors.newSingleThreadExecutor();

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(inputEprParm));
		Iterable<String> input = resultSetClientFactory.getClient(inputEpr);
		final LinkedBlockingQueue<String> publicationsQueue = new LinkedBlockingQueue<String>();
		final SplitterDatasetsIterator splitterIterator = new SplitterDatasetsIterator(publicationsQueue, input, "publications");
		executor.execute(new Runnable() {

			@Override
			public void run() {
				splitterIterator.populateQueues();
			}
		});

		W3CEndpointReference eprUrls_publications = resultSetFactory.createIterableResultSet(new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new IteratorOnQueue<String>(publicationsQueue, SplitterDatasetsIterator.END_QUEUE);
			}
		});

		token.getEnv().setAttribute(getOutputEprParm(), eprUrls_publications.toString());

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the input epr parm.
	 *
	 * @return the inputEprParm
	 */
	public String getInputEprParm() {
		return inputEprParm;
	}

	/**
	 * Sets the input epr parm.
	 *
	 * @param inputEprParm
	 *            the inputEprParm to set
	 */
	public void setInputEprParm(final String inputEprParm) {
		this.inputEprParm = inputEprParm;
	}

	/**
	 * Gets the result set client factory.
	 *
	 * @return the resultSetClientFactory
	 */
	public ResultSetClientFactory getResultSetClientFactory() {
		return resultSetClientFactory;
	}

	/**
	 * Sets the result set client factory.
	 *
	 * @param resultSetClientFactory
	 *            the resultSetClientFactory to set
	 */
	public void setResultSetClientFactory(final ResultSetClientFactory resultSetClientFactory) {
		this.resultSetClientFactory = resultSetClientFactory;
	}

	/**
	 * Gets the output epr parm.
	 *
	 * @return the output epr parm
	 */
	public String getOutputEprParm() {
		return outputEprParm;
	}

	/**
	 * Sets the output epr parm.
	 *
	 * @param outputEprParm
	 *            the new output epr parm
	 */
	public void setOutputEprParm(final String outputEprParm) {
		this.outputEprParm = outputEprParm;
	}

}
