<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"
    xmlns:dnet="eu.dnetlib.miscutils.functional.hash.Hashing"
    xmlns:stringUtils="org.apache.commons.lang.StringUtils">

    <xsl:param name="parentDatasourceId"/>
    <xsl:param name="namespacePrefix"/>

    <xsl:template match="/">
        <record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:dri="http://www.driver-repository.eu/namespace/dri"
            xmlns:dc="http://purl.org/dc/elements/1.1/"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:oaf="http://namespace.openaire.eu/oaf"
            xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

            <xsl:copy-of select=".//*[local-name()='header']"/>
            <metadata>
                <xsl:variable name="rid" select="normalize-space(//column[./@name='ISSN'])"/>
                <xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)"/>
                <xsl:variable name="ISSNNS" select="stringUtils:replace($rid,'-','')"/>
                <xsl:variable name="oName" select="normalize-space(//column[./@name='Title'])"/>
                <xsl:variable name="organizationId"
                    select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')"/>               
                <ROWS>
                    <ROW table="datasources">
                        <FIELD name="id">
                            <xsl:value-of select="$datasourceId"/>
                        </FIELD>
                        <FIELD name="_dnet_resource_identifier_">
                            <xsl:value-of select="$datasourceId"/>
                        </FIELD>
                        <FIELD name="officialname">
                            <xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
                        </FIELD>
                        <FIELD name="englishname">
                            <xsl:value-of select="normalize-space(//column[./@name='Title'])"/>
                        </FIELD>
                        <FIELD name="od_contenttypes">
                            <xsl:value-of select="string('Journal articles')"/>
                        </FIELD>                        
                        <FIELD name="issn">
                            <xsl:value-of select="normalize-space(//column[./@name='ISSN'])"/>
                        </FIELD>
                        <FIELD name="eissn">
                            <xsl:value-of select="normalize-space(//column[./@name='EISSN'])"/>
                        </FIELD>                                              
                        <FIELD name="websiteurl">
                            <xsl:value-of select="normalize-space(//column[./@name='addres'])"/>
                        </FIELD>                       
                        <FIELD name="namespaceprefix">
                            <xsl:value-of select="concat('doaj', $ISSNNS)"/>
                        </FIELD>
                        <FIELD name="datasourceclass">pubsrepository::journal</FIELD>                        
                        <FIELD name="collectedfrom">
                            <xsl:value-of select="$parentDatasourceId"/>
                        </FIELD>
                    </ROW>       
                </ROWS>
            </metadata>
        </record>
    </xsl:template>

</xsl:stylesheet>
