<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:oai="http://www.openarchives.org/OAI/2.0/"
				xmlns:datetime="http://exslt.org/dates-and-times"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:md="http://www.pangaea.de/MetaData"
				xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
				xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:dnet="eu.dnetlib.miscutils.functional.hash.Hashing"
				xmlns:stringUtils="org.apache.commons.lang.StringUtils"
				version="1.0"
				exclude-result-prefixes="xsl dc dnet oaa fn stringUtils datetime">

	<xsl:param name="namespacePrefix"/>
	<xsl:param name="dataSourceId"/>
	<xsl:param name="dataprovider_id"/>

	<xsl:template match="/">
		<xsl:variable name="identifier">
			<xsl:value-of
					select="stringUtils:substringAfter(/*[local-name()='datasetsRecord']/*[local-name()='metadata']/*[local-name()='MetaData']/*[local-name()='citation']/*[local-name()='URI'],'doi:')"
			/>
		</xsl:variable>
		<oai:record>
			<oai:header>
				<dri:objIdentifier>
					<xsl:value-of select="concat($namespacePrefix,'::', dnet:md5($identifier))"/>
				</dri:objIdentifier>
				<dri:recordIdentifier>
					<xsl:value-of select="$identifier"/>
				</dri:recordIdentifier>
				<dri:dateOfCollection>
					<xsl:value-of select="datetime:dateTime()"/>
				</dri:dateOfCollection>
				<dri:repositoryId>
					<xsl:value-of select="$dataSourceId"/>
				</dri:repositoryId>
				<oaf:datasourceprefix>
					<xsl:value-of select="$namespacePrefix"/>
				</oaf:datasourceprefix>
				<dri:repositoryId>
					<xsl:value-of select="$dataprovider_id"/>
				</dri:repositoryId>
			</oai:header>
			<oai:metadata>
				<xsl:copy-of select="."/>
			</oai:metadata>
		</oai:record>

	</xsl:template>
</xsl:stylesheet>
