/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api;

import com.google.gson.Gson;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.openaireplus.api.RecentPublicationsQueue;
import eu.dnetlib.msro.openaireplus.api.objects.PublicationEntry;
import eu.dnetlib.msro.openaireplus.utils.OafToIndexRecordFactory;
import eu.dnetlib.msro.rmi.MSROException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SinglePublicationSubmitter {
    @Value(value="oaf.schema.location")
    private String oafSchemaLocation;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private OafToIndexRecordFactory oafToIndexRecordFactory;
    @Resource
    private RecentPublicationsQueue recentPublicationsQueue;
    @Resource(name="openaireplusApisVelocityEngine")
    private VelocityEngine velocityEngine;
    @Value(value="${openaireplus.msro.api.findSolrIndexUrl.xquery}")
    private ClassPathResource findSolrIndexUrl;
    @Value(value="${openaireplus.msro.api.findIndexDsInfo.xquery}")
    private ClassPathResource findIndexDsInfo;

    @RequestMapping(value={"/api/publications/feedJson"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addPublication(@RequestParam(value="json", required=true) String json) throws MSROException {
        PublicationEntry pub = (PublicationEntry)new Gson().fromJson(json, PublicationEntry.class);
        return this.addPublication(pub);
    }

    @RequestMapping(value={"/api/publications/feedObject"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean addPublication(@RequestBody PublicationEntry pub) throws MSROException {
        if (StringUtils.isBlank((String)pub.getOriginalId())) {
            throw new MSROException("A required field is missing: getOriginalId");
        }
        if (StringUtils.isBlank((String)pub.getTitle())) {
            throw new MSROException("A required field is missing: title");
        }
        if (StringUtils.isBlank((String)pub.getUrl())) {
            throw new MSROException("A required field is missing: url");
        }
        if (StringUtils.isBlank((String)pub.getLicenseCode())) {
            throw new MSROException("A required field is missing: licenceCode");
        }
        if (StringUtils.isBlank((String)pub.getResourceType())) {
            throw new MSROException("A required field is missing: resourceType");
        }
        if (StringUtils.isBlank((String)pub.getCollectedFromId())) {
            throw new MSROException("A required field is missing: collectedFromId");
        }
        try (CloudIndexClient idxClient = null;){
            String baseUrl = this.calculateIndexBaseUrl();
            String[] arr = this.calculateCurrentIndexDsInfo().split("@@@");
            String indexDsId = arr[0].trim();
            String format = arr[1].trim();
            String coll = arr[2].trim();
            idxClient = CloudIndexClientFactory.newIndexClient((String)baseUrl, (String)coll, (boolean)false);
            String oafRecord = pub.asOafRecord(this.velocityEngine, (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class), this.oafSchemaLocation);
            this.recentPublicationsQueue.add(oafRecord);
            boolean bl = idxClient.feed(oafRecord, indexDsId, (UnaryFunction)this.oafToIndexRecordFactory.newTransformer(format)) == 0;
            return bl;
        }
    }

    private String calculateCurrentIndexDsInfo() throws Exception {
        String query = IOUtils.toString((InputStream)this.findIndexDsInfo.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }

    private String calculateIndexBaseUrl() throws Exception {
        String query = IOUtils.toString((InputStream)this.findSolrIndexUrl.getInputStream());
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
    }
}

