<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('irb_hr______')" />

	<xsl:template match="/">
		<fundingtree>
			<xsl:if test="contains(//column[@name='FUNDER_NAME'], 'CSF')">
				<funder>
					<id><xsl:value-of select="concat($namespacePrefix, '::CSF')" /></id>
					<shortname>CSF</shortname>
					<name>Croatian Science Foundation</name>
					<jurisdiction>HR</jurisdiction>
				</funder>
				<funding_level_0>
					<id><xsl:value-of select="concat($namespacePrefix, '::CSF::fundingStream')" /></id>
					<name>Croatian Science Foundation - Funding Stream</name>
					<description>Croatian Science Foundation - Funding Stream</description>
					<parent />
					<class>csf:fundingStream</class>
				</funding_level_0>
			</xsl:if>
		</fundingtree>

	</xsl:template>

</xsl:stylesheet>
