/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.api;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class RecentPublicationsQueue
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(RecentPublicationsQueue.class);
    private DB db;
    private String collection;
    private long maxAge = 30L;

    public void init() {
        if (!this.db.collectionExists(this.collection)) {
            log.info((Object)String.format("creating collection %s", this.collection));
            this.db.createCollection(this.collection, (DBObject)new BasicDBObject());
        }
        this.removeOldEntries();
    }

    @Override
    public Iterator<String> iterator() {
        long start = DateUtils.now() - TimeUnit.DAYS.toMillis(this.maxAge);
        BasicDBObject q = new BasicDBObject("date", (Object)BasicDBObjectBuilder.start((String)"$gte", (Object)start).get());
        final DBCursor cursor = this.db.getCollection(this.collection).find((DBObject)q);
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public String next() {
                DBObject obj = cursor.next();
                return obj != null && obj.containsField("record") ? obj.get("record").toString() : "";
            }

            @Override
            public void remove() {
                throw new RuntimeException("NOT IMPLEMENTED");
            }
        };
    }

    public synchronized void add(String oaf) {
        log.info((Object)("Saving record in db: " + this.db.getName() + ", coll: " + this.collection));
        DBCollection coll = this.db.getCollection(this.collection);
        DBObject obj = BasicDBObjectBuilder.start().append("record", (Object)oaf).append("date", (Object)DateUtils.now()).get();
        coll.insert(new DBObject[]{obj});
    }

    public void removeOldEntries() {
        long start = DateUtils.now() - TimeUnit.DAYS.toMillis(this.maxAge);
        DBCollection coll = this.db.getCollection(this.collection);
        BasicDBObject q = new BasicDBObject("date", (Object)BasicDBObjectBuilder.start((String)"$lt", (Object)start).get());
        coll.remove((DBObject)q);
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    @Required
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public DB getDb() {
        return this.db;
    }

    @Required
    public void setDb(DB db) {
        this.db = db;
    }

    public String getCollection() {
        return this.collection;
    }

    @Required
    public void setCollection(String collection) {
        this.collection = collection;
    }
}

