package eu.dnetlib.msro.openaireplus.api;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;

import com.mongodb.*;
import eu.dnetlib.miscutils.datetime.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

/**
 * Created by michele on 11/11/15.
 */
public class RecentPublicationsQueue implements Iterable<String> {

	private static final Log log = LogFactory.getLog(RecentPublicationsQueue.class);

	private DB db;
	private String collection;

	private long maxAge = 30; //days

	public void init() {
		if (!db.collectionExists(collection)) {
			log.info(String.format("creating collection %s", collection));
			db.createCollection(collection, new BasicDBObject());
		}
		removeOldEntries();
	}

	@Override
	public Iterator<String> iterator() {
		final long start = DateUtils.now() - TimeUnit.DAYS.toMillis(maxAge);

		final BasicDBObject q = new BasicDBObject("date", BasicDBObjectBuilder.start("$gte", start).get());

		final DBCursor cursor = db.getCollection(collection).find(q);

		return new Iterator<String>() {

			@Override
			public boolean hasNext() {
				return cursor.hasNext();
			}

			@Override
			public String next() {
				final DBObject obj = cursor.next();
				return (obj != null && obj.containsField("record")) ? obj.get("record").toString() : "";
			}

			@Override
			public void remove() {
				throw new RuntimeException("NOT IMPLEMENTED");
			}
		};
	}

	synchronized public void add(final String oaf) {
		
		log.info("Saving record in db: " + db.getName() + ", coll: " + collection);

		final DBCollection coll = db.getCollection(collection);
		final DBObject obj = BasicDBObjectBuilder.start()
				.append("record", oaf)
				.append("date", DateUtils.now())
				.get();
		coll.insert(obj);
	}

	public void removeOldEntries() {
		final long start = DateUtils.now() - TimeUnit.DAYS.toMillis(maxAge);
		final DBCollection coll = db.getCollection(collection);
		final BasicDBObject q = new BasicDBObject("date", BasicDBObjectBuilder.start("$lt", start).get());

		coll.remove(q);
	}

	public long getMaxAge() {
		return maxAge;
	}

	@Required
	public void setMaxAge(final long maxAge) {
		this.maxAge = maxAge;
	}

	public DB getDb() {
		return db;
	}

	@Required
	public void setDb(final DB db) {
		this.db = db;
	}

	public String getCollection() {
		return collection;
	}

	@Required
	public void setCollection(final String collection) {
		this.collection = collection;
	}
}
