package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FindVocabularyEntriesJobNode extends SimpleJobNode {

	private String outputEprParam = "epr";

	@javax.annotation.Resource
	private UniqueServiceLocator serviceLocator;

	private Resource xquery;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String query = IOUtils.toString(xquery.getInputStream());
		final W3CEndpointReference epr = serviceLocator.getService(ISLookUpService.class).searchProfile(query);
		token.getEnv().setAttribute(getOutputEprParam(), epr.toString());

		return Arc.DEFAULT_ARC;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public Resource getXquery() {
		return xquery;
	}

	@Required
	public void setXquery(final Resource xquery) {
		this.xquery = xquery;
	}

}
