<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
				xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dnet="eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
				xmlns:fn="http://www.w3.org/2005/xpath-functions" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:variable name="dsId" select="concat($namespacePrefix, '::', normalize-space(.//*[local-name()='re3data.orgIdentifier']))"/>

	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
				xmlns:dri="http://www.driver-repository.eu/namespace/dri"
				xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
				xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<ROW table="datasources">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="$dsId"/>
						</FIELD>
						<FIELD name="id">
							<xsl:value-of select="$dsId"/>
						</FIELD>
						<FIELD name="officialName">
							<xsl:value-of select=".//*[local-name()='repositoryName']"/>
						</FIELD>
						<FIELD name="englishName">
							<xsl:value-of select=".//*[local-name()='additionalName'][@language='eng']"/>
						</FIELD>
						<FIELD name="typology">
							<xsl:value-of select=".//*[local-name()='software']/*[local-name()='softwareName']"/>
						</FIELD>
						<FIELD name="webSiteURL">
							<xsl:value-of select=".//*[local-name()='repositoryURL']"/>
						</FIELD>
						<FIELD name="logoURL"></FIELD>
						<FIELD name="contactEmail"></FIELD>
						<FIELD name="latitude"></FIELD>
						<FIELD name="longitude"></FIELD>
						<FIELD name="timezone"></FIELD>
						<FIELD name="nameSpacePrefix">
							<xsl:value-of select="dnet:generateNsPrefix('r3', dnet:md5(normalize-space(.//*[local-name()='re3data.orgIdentifier'])))"/>
						</FIELD>
						<FIELD name="description">
							<xsl:value-of select="./*[local-name()='description']"/>
						</FIELD>
						<FIELD name="collectedfrom">
							<xsl:value-of select="$parentDatasourceId"/>
						</FIELD>
						<FIELD name="datasourceClass">datarepository::unknown</FIELD>
						<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
						<FIELD name="releaseStartDate" type="date">
							<xsl:value-of select=".//*[local-name()='startDate']"/>
						</FIELD>
						<FIELD name="releaseEndDate" type="date">
							<xsl:value-of select=".//*[local-name()='endDate']"/>
						</FIELD>
						<FIELD name="missionStatementURL">
							<xsl:value-of select=".//*[local-name()='missionStatementURL']"/>
						</FIELD>
						<xsl:choose>
							<xsl:when test=".//*[local-name()='providerType'] = 'dataProvider'">
								<FIELD name="dataProvider" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="dataProvider" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test=".//*[local-name()='providerType'] = 'serviceProvider'">
								<FIELD name="serviceProvider" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="serviceProvider" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<FIELD name="databaseAccessType">
							<xsl:value-of select=".//*[local-name()='databaseAccessType']"/>
						</FIELD>
						<FIELD name="dataUploadType">
							<xsl:value-of select=".//*[local-name()='dataUploadType']"/>
						</FIELD>
						<FIELD name="databaseAccessRestriction">
							<xsl:value-of select=".//*[local-name()='databaseAccessRestriction']"/>
						</FIELD>
						<FIELD name="dataUploadRestriction">
							<xsl:value-of select=".//*[local-name()='dataUploadRestriction']"/>
						</FIELD>
						<xsl:choose>
							<xsl:when test=".//*[local-name()='versioning'] = 'yes'">
								<FIELD name="serviceProvider" type="boolean">true</FIELD>
							</xsl:when>
							<xsl:otherwise>
								<FIELD name="serviceProvider" type="boolean">false</FIELD>
							</xsl:otherwise>
						</xsl:choose>
						<FIELD name="citationGuidelineURL">
							<xsl:value-of select=".//*[local-name()='citationGuidelineURL']"/>
						</FIELD>
						<FIELD name="qualityManagementKind">
							<xsl:value-of select=".//*[local-name()='qualityManagement']"/>
						</FIELD>
						<FIELD name="PIDsystems">
							<xsl:value-of select=".//*[local-name()='pidSystem']"/>
						</FIELD>
						<FIELD name="certificates">
							<xsl:value-of select=".//*[local-name()='certificate']"/>
						</FIELD>
					</ROW>

					<xsl:for-each select="//*[local-name()='api']">
						<xsl:variable name="apiId" select="concat('api_________::', $dsId, '::', position())"/>
						<ROW table="api">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$apiId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$apiId"/>
							</FIELD>
							<FIELD name="protocolclass">
								<xsl:value-of select="normalize-space(@apiType)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="typologyclass">datarepository::unknown</FIELD>
						</ROW>

						<ROW table="apicollections">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($apiId, '@@baseUrl')"/>
							</FIELD>
							<FIELD name="param">baseUrl</FIELD>
							<FIELD name="original">
								<xsl:value-of select="."/>
							</FIELD>
							<FIELD name="api">
								<xsl:value-of select="$apiId"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

					<xsl:for-each select="//*[local-name()='policy']">
						<xsl:variable name="policyURL" select="./*[local-name='policyURL']"/>
						<xsl:variable name="policyId" select="concat($namespacePrefix, '::', dnet:md5($policyURL))"/>
						<ROW table="policies">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$policyId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$policyId"/>
							</FIELD>
							<FIELD name="name">
								<xsl:value-of select="./*[local-name='policyName']"/>
							</FIELD>
							<FIELD name="url">
								<xsl:value-of select="$policyURL"/>
							</FIELD>
						</ROW>

						<ROW table="datasource_policy">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($dsId, '@@', $policyId)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="policy">
								<xsl:value-of select="$policyId"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

					<xsl:for-each select="//*[local-name()='subject']">
						<xsl:variable name="subjectId" select="concat($namespacePrefix, '::DFG_',  substring-before(. , ' '))"></xsl:variable>
						<xsl:variable name="subjectName" select="substring-after(., ' ')"></xsl:variable>
						<ROW table="subjects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
							<FIELD name="name">
								<xsl:value-of select="$subjectName"/>
							</FIELD>
							<FIELD name="semanticclass">DFG</FIELD>
							<FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD>
						</ROW>

						<ROW table="datasource_subject">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($dsId, '@@', $subjectId)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="subject">
								<xsl:value-of select="$subjectId"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

					<xsl:for-each select="//*[local-name()='institution']">
						<xsl:variable name="orgId" select="concat($namespacePrefix, '::', dnet:md5(normalize-space(./*[local-name()='institutionName'])))"/>
						<ROW table="organizations">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$orgId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$orgId"/>
							</FIELD>
							<FIELD name="legalname">
								<xsl:value-of select="./*[local-name()='institutionName']"/>
							</FIELD>
							<FIELD name="legalshortname">
								<xsl:value-of select="./*[local-name()='institutionAdditionalName'][1]"/>
							</FIELD>
							<FIELD name="websiteurl">
								<xsl:value-of select="./*[local-name()='institutionURL']"/>
							</FIELD>
							<FIELD name="countryClass">
								<xsl:value-of select="./*[local-name()='institutionCountry']"/>
							</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
							<FIELD name="provenanceactionclass">sysimport:crosswalk:entityregistry</FIELD>
						</ROW>

						<ROW table="datasource_organization">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="concat($dsId, '@@', $orgId)"/>
							</FIELD>
							<FIELD name="datasource">
								<xsl:value-of select="$dsId"/>
							</FIELD>
							<FIELD name="organization">
								<xsl:value-of select="$orgId"/>
							</FIELD>
							<FIELD name="startdate" type="date">
								<xsl:value-of select="./*[local-name()='responsibilityStartDate']"/>
							</FIELD>
							<FIELD name="enddate" type="date">
								<xsl:value-of select="./*[local-name()='responsibilityEndDate']"/>
							</FIELD>
						</ROW>
					</xsl:for-each>

				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>

