package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.io.StringReader;
import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class PrepareContextDbEntriesJobNode extends SimpleJobNode {

	private String contextObj;
	private String eprParam;

	private static final Log log = LogFactory.getLog(PrepareContextDbEntriesJobNode.class);

	@Resource
	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final ContextDesc desc = (ContextDesc) token.getEnv().getTransientAttribute(contextObj);

		final Iterable<String> iter = Iterables.transform(desc.getDbEntries().entrySet(), new Function<Map.Entry<String, String>, String>() {

			@Override
			public String apply(final Entry<String, String> e) {
				try {
					final SAXReader reader = new SAXReader();

					final Document docFundingPath = reader.read(new StringReader(e.getValue()));

					final Element root = DocumentHelper.createElement("ROWS");

					final Map<String, String> fundingFields = Maps.newLinkedHashMap();
					fundingFields.put("_dnet_resource_identifier_", e.getKey());
					fundingFields.put("id", e.getKey());
					fundingFields.put("path", e.getValue());
					fundingFields.put("jurisdiction", docFundingPath.valueOf("//funder/jurisdiction"));
					fundingFields.put("description", docFundingPath.valueOf("(//*[starts-with(local-name(),'funding_level_')])[1]/description"));

					final Map<String, String> orgFields = findFunderInfo(docFundingPath);
					final String orgId = orgFields.get("id");
					if (StringUtils.isNotBlank(orgId)) {
						addRow(root, "organizations", orgFields);
						fundingFields.put("funder", orgId);
					}

					addRow(root, "fundingpaths", fundingFields);

					if (log.isDebugEnabled()) {
						log.debug("Db entries: " + root.asXML());
					}

					return root.asXML();
				} catch (DocumentException e1) {
					log.error("Error parsing xml", e1);
					throw new RuntimeException("Error parsing xml", e1);
				}
			}

			private Map<String, String> findFunderInfo(final Document doc) {
				final Map<String, String> res = Maps.newLinkedHashMap();
				res.put("_dnet_resource_identifier_", doc.valueOf("//funder/id"));
				res.put("id", doc.valueOf("//funder/id"));
				res.put("legalshortname", doc.valueOf("//funder/shortname"));
				res.put("legalname", doc.valueOf("//funder/name"));
				return res;
			}
		});
		final W3CEndpointReference epr = iterableResultSetFactory.createIterableResultSet(iter);

		token.getEnv().setAttribute(eprParam, epr.toString());

		return Arc.DEFAULT_ARC;
	}

	private void addRow(final Element root, final String table, final Map<String, String> fields) {
		final Element row = root.addElement("ROW");
		row.addAttribute("table", table);
		for (Map.Entry<String, String> e : fields.entrySet()) {
			final Element pathField = row.addElement("FIELD");
			pathField.addAttribute("name", e.getKey());
			pathField.setText(e.getValue());
		}
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
