package eu.dnetlib.download.plugin;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class PathRetreiver {

	private static PathRetreiver instance;

	public static PathRetreiver getInstance(final String base_path) {
		if (instance == null) {
			instance = new PathRetreiver();
			instance.setBase_path(base_path);
		}
		return instance;
	}

	private String base_path;

	private List<InfoPath> values;

	private void bootstrap() {
		values = new ArrayList<InfoPath>();
		File basePath = new File(this.base_path);
		File[] selectedFiles = basePath.listFiles(new FileFilter() {

			@Override
			public boolean accept(final File pathname) {
				return pathname.isDirectory();
			}
		});

		for (File f : selectedFiles) {
			String lower = StringUtils.substringAfter(StringUtils.substringBefore(f.getName(), "_"), "PMC");
			String upper = StringUtils.substringAfter(StringUtils.substringAfter(f.getName(), "_"), "PMC");
			String path = f.getPath();
			InfoPath i = new InfoPath();
			i.setLower(Integer.parseInt(lower));
			i.setUpper(Integer.parseInt(upper));
			i.setPath(path);
			values.add(i);
		}

		Collections.sort(values, new Comparator<InfoPath>() {

			@Override
			public int compare(final InfoPath o1, final InfoPath o2) {
				if (o1.getLower() < o2.getLower()) return -1;
				else if (o1.getLower() < o2.getLower()) return 0;
				else return 1;
			}
		});

	}

	public String getPathForPMCID(final int pmcID) {
		if (values == null) {
			bootstrap();
		}
		for (int i = 0; i < values.size(); i++) {
			if (pmcID < values.get(i).getLower()) {
				if (i == 0) return null;
				File f = new File(values.get(i - 1).getPath() + "/" + pmcID + ".xml");
				String s = null;
				if (f.exists()) {
					s = f.getPath();
				}

				return s;

			}
		}
		return null;
	}

	public void setBase_path(final String base_path) {
		this.base_path = base_path;
	}

	public String getBase_path() {
		return this.base_path;
	}
}
