<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("harv_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transform"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="transform"/>
	</ARCS>
</NODE>

<NODE name="transform" type="Transform" isJoin="true">
	<DESCRIPTION>Transform original records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="ruleId" managedBy="user" category="TRANSFORMATION_RULE_ID" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">tran_epr</PARAM>		 
	</PARAMETERS>
	<ARCS>
		<ARC to="patchHostedBy"/>
	</ARCS>
</NODE>

<NODE name="patchHostedBy" type="PatchHostedBy">
	<DESCRIPTION>Patch oaf:hostedBy fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">tran_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">patched_epr</PARAM>		 
		<PARAM required="true" type="string" name="dbName" managedBy="user">dnet_openaireplus</PARAM>
		<PARAM required="true" type="string" name="countersParam" managedBy="system">hostedByCounters</PARAM>
		<PARAM required="true" type="string" name="hostedbyMapTable" managedBy="user">hostedby_map</PARAM>
		<PARAM required="true" type="string" name="xpathEntry" managedBy="user">//*[local-name()='header']/*[local-name()='setSpec']</PARAM>
	    <PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="system">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">patched_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_INFO"/>
	</ARCS>
</NODE>

 <NODE name="UPDATE_INFO" type="MDStoreToApiExtraField">
	<DESCRIPTION>Update datasouce API extra fields</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="datasourceInterface" managedBy="system">$params.("dataprovider:interface")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldForTotal" managedBy="system">last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="validateHostedByRepos"/>
	</ARCS>
</NODE>

<NODE name="validateHostedByRepos" type="UpsertHostedByApis">
	<DESCRIPTION>Validate hostedBy Repos</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="countersParam" managedBy="system">hostedByCounters</PARAM>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="extraFieldsForTotal" managedBy="system">datacite::last_aggregation_total</PARAM>
		<PARAM required="true" type="string" name="extraFieldForDate" managedBy="system">datacite::last_aggregation_date</PARAM>
		<PARAM required="true" type="string" name="extraFieldForMdId" managedBy="system">datacite::last_aggregation_mdId</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
