<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:ands="http://ands.org.au/standards/rif-cs/registryObjects"
	exclude-result-prefixes="fn">

	<xsl:output indent="yes" />

	<xsl:template match="/">
		<fundings>
			<xsl:for-each select="//ands:description[@type='fundingScheme']">
				<fundingtree>
					<funder>
						<id>nhmrc_______::NHMRC</id>
						<shortname>NHMRC</shortname>
						<name>National Health and Medical Research Council (NHMRC)</name>
						<jurisdiction>AU</jurisdiction>
					</funder>
					<funding_level_0>
						<id>
							<xsl:value-of
								select="concat('nhmrc_______::NHMRC::', normalize-space(.))" />
						</id>
						<name>
							<xsl:value-of select="normalize-space(.)" />
						</name>
						<description>
							<xsl:value-of select="normalize-space(.)" />
						</description>
						<parent></parent>
						<class>nhmrc:fundingStream</class>
					</funding_level_0>
				</fundingtree>
			</xsl:for-each>
		</fundings>
	</xsl:template>
</xsl:stylesheet>
