<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('irb_hr______')" />

	<xsl:template match="/">
		<fundingtree>
			<xsl:choose>
				<xsl:when test="normalize-space(//column[@name='FUNDER_NAME']) = 'Ministry of Science Education and Sport, MSES'">
					<funder>
						<id><xsl:value-of select="concat($namespacePrefix, '::MSES')" /></id>
						<shortname>MSES</shortname>
						<name>Ministry of Science Education and Sport</name>
						<jurisdiction>HR</jurisdiction>
					</funder>
					<funding_level_0>
						<id><xsl:value-of select="concat($namespacePrefix, '::MSES::fundingStream')" /></id>
						<name>MSES Funding Stream</name>
						<description>MSES Funding Stream</description>
						<parent />
						<class>mses:fundingStream</class>
					</funding_level_0>
				</xsl:when>
				<xsl:when test="normalize-space(//column[@name='FUNDER_NAME']) = 'Croatian Science Foundation, CSF'">
					<funder>
						<id><xsl:value-of select="concat($namespacePrefix, '::CSF')" /></id>
						<shortname>CSF</shortname>
						<name>Croatian Science Foundation</name>
						<jurisdiction>HR</jurisdiction>
					</funder>
					<funding_level_0>
						<id><xsl:value-of select="concat($namespacePrefix, '::CSF::fundingStream')" /></id>
						<name>CSF Funding Stream</name>
						<description>CSF Funding Stream</description>
						<parent />
						<class>csf:fundingStream</class>
					</funding_level_0>
				</xsl:when>
			</xsl:choose>
		</fundingtree>

	</xsl:template>

</xsl:stylesheet>
