<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('fct_________')" />
	<xsl:variable name="funderID" select="concat($namespacePrefix, '::FCT')" />
	
	<xsl:template match="/">

		<xsl:variable name="funding">
			<xsl:choose>
				<xsl:when test="normalize-space(.//funding/program)">
					<xsl:value-of select="normalize-space(.//funding/program)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="string('UNKNOWN')" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<fundingtree>
			<funder>
				<id>
					<xsl:value-of select="$funderID" />
				</id>
				<shortname>FCT</shortname>
				<name>Fundação para a Ciência e a Tecnologia, I.P.</name>
				<jurisdiction>PT</jurisdiction>
			</funder>
			<funding_level_0>
				<id>
					<xsl:value-of select="concat($funderID,'::', $funding)" />
				</id>
				<description>
					<xsl:value-of select="$funding" />
				</description>
				<name>
					<xsl:value-of select="$funding" />
				</name>
				<parent></parent>
				<class>fct:program</class>
			</funding_level_0>
		</fundingtree>
	</xsl:template>

</xsl:stylesheet>
