<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
		<PARAM required="true" type="string" name="api" managedBy="system">$params.("dataprovider:interface")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="PREPARE_DB"/>
	</ARCS>
</NODE>

<NODE name="PREPARE_DB" type="ExecuteSql">
	<DESCRIPTION>Create necessary tables</DESCRIPTION>
    <PARAMETERS>
    	<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
        <PARAM name="sql" type="string" managedBy="system" required="true">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/sql-datacite/dataciteSets_prepareTables.sql</PARAM>
	</PARAMETERS>
    <ARCS>
		<ARC to="FETCH_SETS_FROM_MDSTORE"/>
		<ARC to="FETCH_DATAREPOS"/>
	</ARCS>
</NODE>

<NODE name="FETCH_SETS_FROM_MDSTORE" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system" category="MDSTORE_ID">$params.("row_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("row_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">rs_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_SETS_DB"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_SETS_DB" type="UpdateOpenaireDb">
	<DESCRIPTION>Update Db</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">rs_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="FIND_MATCHES"/>
	</ARCS>
</NODE>

<NODE name="FETCH_DATAREPOS" type="QueryDb">
	<DESCRIPTION>Fetch records by Query</DESCRIPTION>
	<PARAMETERS>
		<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
		<PARAM name="sql" type="string" managedBy="system" required="true">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/sql-datacite/dataciteSets_findDataRepos.sql</PARAM>
		<PARAM name="outputEprParam" type="string" managedBy="system" required="true">sql_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="CLEAN_DATAREPOS" />
	</ARCS>
</NODE>

<NODE name="CLEAN_DATAREPOS" type="ApplyXslt">
	<DESCRIPTION>Transform original records in DB rows</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="system">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite/datacite_datarepos_2_db.xslt</PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">sql_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">clean_sql_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="UPDATE_DATAREPOS_DB"/>
	</ARCS>
</NODE>

<NODE name="UPDATE_DATAREPOS_DB" type="UpdateOpenaireDb">
	<DESCRIPTION>Update Db with cleaned datarepos</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">clean_sql_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="FIND_MATCHES"/>
	</ARCS>
</NODE>

<NODE name="FIND_MATCHES" type="ExecuteSql" isJoin="true">
	<DESCRIPTION>Create necessary tables</DESCRIPTION>
    <PARAMETERS>
    	<PARAM name="dbProperty" type="string" managedBy="system" required="true">dnet.openaire.db.name</PARAM>
        <PARAM name="sql" type="string" managedBy="system" required="true">/eu/dnetlib/msro/openaireplus/workflows/repo-hi/sql-datacite/dataciteSets_findMatches.sql</PARAM>
	</PARAMETERS>
    <ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>