CREATE TYPE IIS_STATUS AS ENUM ('unsolved', 'solved');
CREATE TYPE STATUS AS ENUM ('pending', 'accepted', 'refused', 'deleted');

CREATE TABLE blacklist (

	userid character varying(255) NOT NULL,
	semantic_class character varying(255) NOT NULL,
	semantic_scheme character varying(255) NOT NULL,
	hbase_relation_type_encoding character varying(255) NOT NULL,
	provenance character varying(255) NOT NULL,
	iis_module character varying(255) NOT NULL,
	iis_module_profile character varying(255),
	
	iis_status IIS_STATUS NOT NULL,
	status STATUS NOT NULL,

	source_object character varying(255) NOT NULL,
	target_object character varying(255) NOT NULL,

	original_source_objects character varying(255) ARRAY,
	original_target_objects character varying(255) ARRAY,

	creation_time timestamp default now(),
	last_update_time timestamp default now(),
	
	note text,
	ticket_id character varying(255)
);