package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import java.io.StringReader;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;

public class ProcessContextsJobNode extends SimpleJobNode implements ProgressJobNode {

	private String eprParam;
	private String contextObj;
	private ResultsetProgressProvider progressProvider;
	private String contextId;
	private String contextLabel;
	private String contextType;

	private static final Log log = LogFactory.getLog(ProcessContextsJobNode.class);

	@Resource
	private ResultSetClientFactory resultSetClientFactory;

	@Resource
	private ProcessCountingResultSetFactory processCountingResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final ContextDesc context = new ContextDesc(contextId, contextLabel, contextType);

		final String epr = token.getEnv().getAttribute(eprParam);

		this.progressProvider = processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);

		final SAXReader reader = new SAXReader();

		for (String s : resultSetClientFactory.getClient(progressProvider.getEpr())) {
			final Document doc = reader.read(new StringReader(s));

			for (Object o : doc.selectNodes("//fundingtree")) {
				final Element treeNode = (Element) o;
				final String openaireId = treeNode.valueOf("./*[starts-with(local-name(),'funding_level_')]/id");
				if (!context.getDbEntries().containsKey(openaireId)) {
					log.info("Found funding: " + openaireId);
					context.getDbEntries().put(openaireId, treeNode.asXML());
					final Node node0 = treeNode.selectSingleNode(".//funding_level_0");
					if (node0 != null) {
						final ContextPart part = calculatePart(node0);
						if (context.getCategories().containsKey(part.getId())) {
							for (ContextPart p : part.getParts().values()) {
								context.getCategories().get(part.getId()).addPart(p);;
							}
						} else {
							context.getCategories().put(part.getId(), part);
						}
					}
				}
			}
		}

		token.getEnv().setTransientAttribute(contextObj, context);

		return Arc.DEFAULT_ARC;
	}

	private ContextPart calculatePart(final Node node) {

		// final String newId = contextId + "::" + StringUtils.substringAfter(node.valueOf("./id"), "::");
		// ids are built as: nsPrefix :: funderID :: fundingLevel0ID :: etc etc, hence it seems we might not need the contextId parameter.
		final String newId = StringUtils.substringAfter(node.valueOf("./id"), "::");

		final ContextPart part = new ContextPart(newId, node.valueOf("./description"));

		part.getParams().put("name", node.valueOf("./name"));
		part.getParams().put("openaireId", node.valueOf("./id"));
		part.getParams().put("class", node.valueOf("./class"));

		final Element parent = node.getParent() != null ? node.getParent().getParent() : null;

		if (parent != null && parent.getName().startsWith("funding_level_")) {
			final ContextPart p = calculatePart(parent);
			part.getParts().put(p.getId(), p);
		}
		return part;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getContextObj() {
		return contextObj;
	}

	public void setContextObj(final String contextObj) {
		this.contextObj = contextObj;
	}

	@Override
	public ProgressProvider getProgressProvider() {
		return progressProvider;
	}

	public String getContextId() {
		return contextId;
	}

	public void setContextId(final String contextId) {
		this.contextId = contextId;
	}

	public String getContextLabel() {
		return contextLabel;
	}

	public void setContextLabel(final String contextLabel) {
		this.contextLabel = contextLabel;
	}

	public String getContextType() {
		return contextType;
	}

	public void setContextType(final String contextType) {
		this.contextType = contextType;
	}
}
