<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"
    xmlns:clean="eu.dnetlib.msro.openaireplus.utils.CleaningXsltFunctions">
    
    
    <xsl:param name="parentDatasourceId"/>
    <xsl:template match="/">
        
        <ROWS>
            <xsl:variable name="issn" select="//column[./@name='ISSN']" />
            <xsl:variable name="id" select="//column[./@name='ID']" />           
            
            <ROW table="pangaea_temp_journals">
                <FIELD name="_dnet_resource_identifier_">
                    <xsl:value-of select="concat('journal',$id)" />
                </FIELD>
                <FIELD name="id">
                    <xsl:value-of select="concat('journal',$id)" />
                </FIELD>
                <FIELD name="issn">
                    <xsl:value-of select="$issn" />
                </FIELD>
                <FIELD name="oa_source_id">
                    <xsl:value-of select="$parentDatasourceId" />
                </FIELD>                
            </ROW>
        </ROWS>
    </xsl:template>
</xsl:stylesheet>