/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import eu.dnetlib.download.plugin.InfoPath;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PathRetreiver {
    private static PathRetreiver instance;
    private String base_path;
    private List<InfoPath> values;

    public static PathRetreiver getInstance(String base_path) {
        if (instance == null) {
            instance = new PathRetreiver();
            instance.setBase_path(base_path);
        }
        return instance;
    }

    private void bootstrap() {
        File[] selectedFiles;
        this.values = new ArrayList<InfoPath>();
        File basePath = new File(this.base_path);
        for (File f : selectedFiles = basePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            String lower = StringUtils.substringAfter((String)StringUtils.substringBefore((String)f.getName(), (String)"_"), (String)"PMC");
            String upper = StringUtils.substringAfter((String)StringUtils.substringAfter((String)f.getName(), (String)"_"), (String)"PMC");
            String path = f.getPath();
            InfoPath i = new InfoPath();
            i.setLower(Integer.parseInt(lower));
            i.setUpper(Integer.parseInt(upper));
            i.setPath(path);
            this.values.add(i);
        }
        Collections.sort(this.values, new Comparator<InfoPath>(){

            @Override
            public int compare(InfoPath o1, InfoPath o2) {
                if (o1.getLower() < o2.getLower()) {
                    return -1;
                }
                if (o1.getLower() < o2.getLower()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public String getPathForPMCID(int pmcID) {
        if (this.values == null) {
            this.bootstrap();
        }
        for (int i = 0; i < this.values.size(); ++i) {
            if (pmcID >= this.values.get(i).getLower()) continue;
            if (i == 0) {
                return null;
            }
            File f = new File(this.values.get(i - 1).getPath() + "/" + pmcID + ".xml");
            String s = null;
            if (f.exists()) {
                s = f.getPath();
            }
            return s;
        }
        return null;
    }

    public void setBase_path(String base_path) {
        this.base_path = base_path;
    }

    public String getBase_path() {
        return this.base_path;
    }
}

