var module = angular.module('statsInspector', ['ngRoute', 'statInspectorControllers']);

var endDate = new Date();
var startDate = new Date();

// Set date range to [7 days before today, today] inclusive
startDate.setDate(endDate.getDate()-7);

module.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
			.when('/list/:from/:to/:procid',     { templateUrl: '../resources/html/stats/list.html',       controller: 'listStatsCtrl' })
			.when('/history', 			  		 { templateUrl: '../resources/html/stats/history.html',    controller: 'historyStatsCtrl' })
			.otherwise({ redirectTo: '/list/' + encodeDateParam(startDate) + '/' + encodeDateParam(endDate) + '/x' });
	}
]);

module.controller('moduleMenuCtrl', [ '$scope', '$location',  
	function ($scope, $location) {
		$scope.isActive = function(regex) {
			var re = new RegExp(regex);
			return re.test($location.path());
		}
	}
]);

module.filter('encodeURIComponent', function() {
    return window.encodeURIComponent;
});

module.filter('reverse', function () {
	return function(items) {
		return items.slice().reverse();
	}
});

function encodeDateParam(date) {
	var year = date.getFullYear();
	var month = ("00" + (date.getMonth() + 1)).slice(-2);
	var day = ("00" + date.getDate()).slice(-2);
	return year + month + day;
}

function decodeDateParam(s) {
	var year = s.substring(0,4);
	var month = s.substring(4,6);
	var day = s.substring(6,8);

	return new Date(year,month-1,day);
}

module.directive('sliderDateRange', function($compile) {
	var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sept", "Oct", "Nov", "Dec"];
	return {
		restrict: 'A',
		scope: {
			start : '=',
			end   : '=',
			updateFunction: '='
		},
		link: function(scope, elem, attrs) {
    		$(elem).dateRangeSlider({
    			valueLabels: "change",
    			delayOut: 1000,
    			"bounds" : {
					min: new Date(2014, 0, 1),
					max: new Date()
				},
				"defaultValues" : {
					min: scope.start,
					max: scope.end
				},
				"scales": [{
					first: function(value) {
						return value;
					},
					end: function(value) {
						return value;
					},
					next: function(value) {
						var next = new Date(value);
						return new Date(next.setMonth(value.getMonth() + 1));
					},
					label: function(value) {
						return months[value.getMonth()];
					},
					format:	function(tickContainer, tickStart, tickEnd) {
						tickContainer.addClass("myCustomClass");
					}
				}]
    		});
    		$(elem).bind("valuesChanged", function(e, data){
    			scope.updateFunction(data.values.min, data.values.max);
    		});
    	}
    }
});

module.directive('compileTemplate', function($compile, $parse){
    return {
        link: function(scope, element, attr){
            var parsed = $parse(attr.ngBindHtml);

            function getStringValue() { return (parsed(scope) || '').toString(); }

            //Recompile if the template changes
            scope.$watch(getStringValue, function() {
            	$compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
            });
        }
    }
});

