<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	
	<xsl:param name="parentDatasourceId" />
	
	<xsl:template name="dateCorda">
		<xsl:param name="datename" />
		<xsl:param name="datevalue" />
		<FIELD name="{$datename}" type="date" format="dd/MM/yyyy"><xsl:value-of select="$datevalue" /></FIELD>
	</xsl:template>
	
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
			xmlns:dri="http://www.driver-repository.eu/namespace/dri"
			xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
			
			<xsl:copy-of select=".//*[local-name()='header']"/>
			
			<metadata>
				<ROWS>
					<xsl:for-each select=".//project">

						<xsl:variable name="projectId" select="concat('corda__h2020::', normalize-space(./@id))"/>
						<xsl:variable name="level2">
							<xsl:choose>
								<xsl:when test="starts-with(./funding/@code, 'Euratom')">
									<xsl:value-of select="string('Euratom')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="string('EC')"/>
								</xsl:otherwise>							
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="level3" select="normalize-space(./funding/@code)" />
						<xsl:variable name="fundingId" select="concat('ec_h2020fund::H2020::', normalize-space($level2), '::', $level3)" /> 

						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="id"><xsl:value-of select="$projectId" /></FIELD>
							<FIELD name="code"><xsl:value-of select="./@id" /></FIELD>
							<FIELD name="acronym"><xsl:value-of select="./title/@acronym" /></FIELD>
							<FIELD name="title"><xsl:value-of select="./title" /></FIELD>
							<FIELD name="startdate" type="date" format="dd/MM/yyyy"><xsl:value-of select="./date/@start" /></FIELD>
							<FIELD name="enddate" type="date" format="dd/MM/yyyy"><xsl:value-of select="./date/@end" /></FIELD>
							<FIELD name="call_identifier"><xsl:value-of select="./@callId" /></FIELD>
							<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
							<FIELD name="contracttypeclass"><xsl:value-of select="./toa[@level=1]/@code" /></FIELD>
							<FIELD name="contracttypescheme">ec:h2020toas</FIELD>
							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
						</ROW>
						
						<xsl:if test="string-length($level3) &gt; 0">
							<ROW table="project_fundingpath">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($fundingId, '@@', $projectId)"/></FIELD>
								<FIELD name="funding"><xsl:value-of select="$fundingId" /></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="startdate" type="date" format="dd/MM/yyyy"><xsl:value-of select="./date/@start" /></FIELD>
								<FIELD name="enddate" type="date" format="dd/MM/yyyy"><xsl:value-of select="./date/@end" /></FIELD>
								<FIELD name="semanticclass"><xsl:value-of select="./toa[@level=1]/@code" /></FIELD>
								<FIELD name="semanticscheme">ec:h2020toas</FIELD>
							</ROW>
						</xsl:if>
					
						<xsl:for-each select=".//participants/organization">
							<xsl:variable name="organizationId" select="concat('corda__h2020::', @id)" />
							<ROW table="organizations">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="id"><xsl:value-of select="$organizationId" /></FIELD>
								<FIELD name="legalshortname"><xsl:value-of select="./name/@shortName" /></FIELD>
								<FIELD name="legalname"><xsl:value-of select="./name" /></FIELD>
								<FIELD name="countryclass"><xsl:value-of select="./country" /></FIELD>
								<FIELD name="countryscheme">dnet:countries</FIELD>
								<FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
							
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_"><xsl:value-of select='concat($projectId, "@@", $organizationId)' /></FIELD>
								<FIELD name="participantnumber" type="int"><xsl:value-of select="position()"></xsl:value-of></FIELD>
								<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
								<FIELD name="resporganization"><xsl:value-of select="$organizationId" /></FIELD>
								<xsl:choose>
									<xsl:when test="position() = 1">
										<FIELD name="contactperson"></FIELD>
										<FIELD name="semanticclass">coordinator</FIELD>
									</xsl:when>
									<xsl:otherwise>
										<FIELD name="contactperson"></FIELD>
										<FIELD name="semanticclass">participant</FIELD>
									</xsl:otherwise>
								</xsl:choose>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:for-each>
					</xsl:for-each>		
				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>
