<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="fn">

	<xsl:variable name="namespacePrefix" select="string('ec_h2020fund')"/>

	<xsl:template match="/">
	
		<fundings>
			<fundingtree>
				<funder>
					<id>ec__________::EC</id>
					<name>EC</name>
					<description>European Commission</description>
					<jurisdiction>EU</jurisdiction>
				</funder>
				<xsl:call-template name="level3" />
			</fundingtree>
			<xsl:if test="string-length(//level_4/@code) &gt; 0">
				<fundingtree>
					<funder>
						<id>ec__________::EC</id>
						<shortname>EC</shortname>
						<name>European Commission</name>
						<jurisdiction>EU</jurisdiction>
					</funder>
					<funding_level_3>
						<id><xsl:value-of select="concat($namespacePrefix, '::', //level_1/@code, '::', //level_2/@code, '::', //level_3/@code, '::', //level_4/@code)" /></id>
						<description><xsl:value-of select="//level_4" /></description>
						<name><xsl:value-of select="//level_4/@code" /></name>
						<class>ec:h2020fundings</class>
						<parent>
							<xsl:call-template name="level3" />
						</parent>
					</funding_level_3>
				</fundingtree>
			</xsl:if>
		</fundings>
	</xsl:template>
	
	<xsl:template name="level3">
		<funding_level_2>
			<id><xsl:value-of select="concat($namespacePrefix, '::', //level_1/@code, '::', //level_2/@code, '::', //level_3/@code)" /></id>
			<description><xsl:value-of select="//level_3" /></description>
			<name><xsl:value-of select="//level_3/@code" /></name>
			<class>ec:h2020fundings</class>
			<parent>
				<funding_level_1>
					<id><xsl:value-of select="concat($namespacePrefix, '::', //level_1/@code, '::', //level_2/@code)" /></id>
					<description><xsl:value-of select="//level_2" /></description>
					<name><xsl:value-of select="//level_2/@code" /></name>
					<class>ec:h2020fundings</class>
					<parent>
						<funding_level_0>
							<id><xsl:value-of select="concat($namespacePrefix, '::', //level_1/@code)" /></id>
							<description><xsl:value-of select="//level_1" /></description>
							<name><xsl:value-of select="//level_1/@code" /></name>
							<class>ec:h2020fundings</class>
							<parent />
						</funding_level_0>
					</parent>
				</funding_level_1>
			</parent>
		</funding_level_2>
	</xsl:template>

</xsl:stylesheet>
