/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dataFlowMonitoring;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.Sensor;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.SensorWrapper;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.monitoring.core.sensors.collection.kv.redis.RedisSensor;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerPrepublicMonitoringScenarioJobNode
extends SimpleJobNode {
    private final Log log = LogFactory.getLog(TriggerPrepublicMonitoringScenarioJobNode.class);
    private static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";
    private String solrXquery;
    @Resource
    private UniqueServiceLocator serviceLocator;
    private SolrSensor solrSensor;
    private RedisSensor redisSensor;
    private SensorWrapper wrapper;

    protected String execute(NodeToken token) throws IOException, InstantiationException, IllegalAccessException, InterruptedException, ISLookUpException {
        this.log.info((Object)"Execution of TriggerPrepublicMonitoringScenarioJobNode");
        String actualCollection = this.evaluateCurrentSolrCollection();
        this.log.info((Object)("At this round, the Pre-public monitoring scenario will check against " + actualCollection + "SOLR collection"));
        this.solrSensor = (SolrSensor)SensorFactory.createSensorWithConfiguration(SolrSensor.class, (String)"solr");
        this.solrSensor.getConfiguration().setParam("collection", (Object)actualCollection);
        this.redisSensor = (RedisSensor)SensorFactory.createSensorWithConfiguration(RedisSensor.class, (String)"redis");
        this.wrapper = (SensorWrapper)SensorFactory.createSensor(SensorWrapper.class);
        this.wrapper.registerSensor((Sensor)this.solrSensor);
        this.wrapper.registerSensor((Sensor)this.redisSensor);
        this.log.info((Object)"Measuring prepublic scenario");
        this.wrapper.measure();
        this.log.info((Object)"DONE!");
        return Arc.DEFAULT_ARC;
    }

    private String evaluateCurrentSolrCollection() throws ISLookUpException {
        List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(this.solrXquery);
        if (list.size() != 1) {
            throw new ISLookUpException("Exactly one collection in SOLR should be the public one!");
        }
        if (SolrCollections.TMF.equals(list.get(0))) {
            return (Object)((Object)SolrCollections.DMF) + SOLR_COLLECTION_POSTFIX;
        }
        return (Object)((Object)SolrCollections.TMF) + SOLR_COLLECTION_POSTFIX;
    }

    public String getSolrXquery() {
        return this.solrXquery;
    }

    public void setSolrXquery(String solrXquery) {
        this.solrXquery = solrXquery;
    }

    private static enum SolrCollections {
        TMF,
        DMF;

    }
}

