/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.contexts;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.msro.openaireplus.workflows.nodes.contexts.ContextDesc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PrepareContextDbEntriesJobNode
extends SimpleJobNode {
    private String contextObj;
    private String eprParam;
    private static final Log log = LogFactory.getLog(PrepareContextDbEntriesJobNode.class);
    @Resource
    private IterableResultSetFactory iterableResultSetFactory;

    protected String execute(NodeToken token) throws Exception {
        ContextDesc desc = (ContextDesc)token.getEnv().getTransientAttribute(this.contextObj);
        Iterable iter = Iterables.transform(desc.getDbEntries().entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> e) {
                try {
                    SAXReader reader = new SAXReader();
                    Document docFundingPath = reader.read((Reader)new StringReader(e.getValue()));
                    Element root = DocumentHelper.createElement((String)"ROWS");
                    LinkedHashMap fundingFields = Maps.newLinkedHashMap();
                    fundingFields.put("_dnet_resource_identifier_", e.getKey());
                    fundingFields.put("id", e.getKey());
                    fundingFields.put("path", e.getValue());
                    fundingFields.put("jurisdiction", docFundingPath.valueOf("//funder/jurisdiction"));
                    fundingFields.put("description", docFundingPath.valueOf("(//*[starts-with(local-name(),'funding_level_')])[1]/description"));
                    Map<String, String> orgFields = this.findFunderInfo(docFundingPath);
                    String orgId = orgFields.get("id");
                    if (StringUtils.isNotBlank((String)orgId)) {
                        PrepareContextDbEntriesJobNode.this.addRow(root, "organizations", orgFields);
                        fundingFields.put("funder", orgId);
                    }
                    PrepareContextDbEntriesJobNode.this.addRow(root, "fundingpaths", fundingFields);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Db entries: " + root.asXML()));
                    }
                    return root.asXML();
                }
                catch (DocumentException e1) {
                    log.error((Object)"Error parsing xml", (Throwable)e1);
                    throw new RuntimeException("Error parsing xml", e1);
                }
            }

            private Map<String, String> findFunderInfo(Document doc) {
                LinkedHashMap res = Maps.newLinkedHashMap();
                res.put("_dnet_resource_identifier_", doc.valueOf("//funder/id"));
                res.put("id", doc.valueOf("//funder/id"));
                res.put("legalshortname", doc.valueOf("//funder/shortname"));
                res.put("legalname", doc.valueOf("//funder/name"));
                return res;
            }
        });
        W3CEndpointReference epr = this.iterableResultSetFactory.createIterableResultSet(iter);
        token.getEnv().setAttribute(this.eprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    private void addRow(Element root, String table, Map<String, String> fields) {
        Element row = root.addElement("ROW");
        row.addAttribute("table", table);
        for (Map.Entry<String, String> e : fields.entrySet()) {
            Element pathField = row.addElement("FIELD");
            pathField.addAttribute("name", e.getKey());
            pathField.setText(e.getValue());
        }
    }

    public String getContextObj() {
        return this.contextObj;
    }

    public void setContextObj(String contextObj) {
        this.contextObj = contextObj;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

