var dedupInspectorControllers = angular.module('dedupInspectorControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { document.location.href='#'+path; }
	$scope.encodeValue      = function(val)     { return val; }
	
	
	$scope.encodeDateParam = function(date) {
		var year = date.getFullYear();
		var month = ("00" + (date.getMonth() + 1)).slice(-2);
		var day = ("00" + date.getDate()).slice(-2);
		return year + month + day;
	}

	$scope.decodeDateParam = function(s) {
		var year = s.substring(0,4);
		var month = s.substring(4,6);
		var day = s.substring(6,8);

		return new Date(year,month-1,day);
	}
}

dedupInspectorControllers.controller('addSimRelsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {
	
		common_init($scope, $http, $sce, $location);
	
		$scope.validEntityTypes = { 
			'result' 		: 	{id:'50', type:'result', label:'Publication'}, 
			'organization' 	: 	{id:'20', type:'organization', label:'Organization'} 
		};
		$scope.group = {
			group : [],
			entitytype : $scope.validEntityTypes[$routeParams.entitytype]
		};			

		$scope.groupIdDetails = {};
		
		if($routeParams.query && $routeParams.query.length > 0) {
			$scope.query = $routeParams.query;
		}
		if($routeParams.start) {
			$scope.start = parseInt($routeParams.start);			
		} else {
			$scope.start = 0;
		}
		$scope.rows = 20;
	
		$scope.search = function() {
			$scope.showSpinner();
			var q = '';
			if($scope.query.match('^[0-9][0-9]\|.{12}::[a-zA-Z0-9]{32}$')) {
				q = 'objidentifier exact "' + $scope.query + '"';
			} else {
				q = $scope.query;
			}			
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('dedup/search.do', $.param({
				'entitytype' : $scope.group.entitytype.type,
				'query'  : q,
				'start'	 : $scope.start,
				'rows'	 : $scope.rows
			})).success(function(res) {
            	if(res) {
            		$scope.results = res;
            		$scope.hideSpinner();
            	} else {
                	$scope.hideSpinner();
            		$scope.showError('Registration failed');
            	}
			}).error(function(err) {
				$scope.hideSpinner();
				$scope.showError('Registration failed: ' + err.message);
			});			
		}		
		
		if($scope.query) {
			$scope.search();
		}
		
		$scope.resetForm = function() {
			if (confirm('Reset group?')) {
				$scope.group.group = [];
				$scope.groupIdDetails = {};
			}
		}
		
		$scope.registerSimilarities = function() {
			if (confirm('Add new similarity group?')) {
				$scope.showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('dedup/addSimRels.do', $.param($scope.group)).success(function(res) {
	            	if(res) {
	            		$scope.showNotification('The Similarities has been registered');
	            		$scope.hideSpinner();
	            		$scope.resetForm();
	            	} else {
	                	$scope.hideSpinner();
	            		$scope.showError('Registration failed');
	            	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Registration failed: ' + err.message);
				});
			}
		}

		$scope.updateSimilarities = function() {
			if (confirm('Update similarity group?')) {
				$scope.showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('dedup/updateSimRels.do', $.param({
					'groupid' : $scope.group.id,
					'entityType' : $scope.group.entitytype.id,
					'idsCsv'  : $scope.group.group.join()
				})).success(function(res) {
	            	if(res) {
	            		$scope.showNotification('The Similarities has been updated');
	            		$scope.hideSpinner();
	            		$scope.resetForm();
	            		$scope.go('/edit/' + $scope.groupid);
	            	} else {
	                	$scope.hideSpinner();
	            		$scope.showError('Registration failed');
	            	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Registration failed: ' + err.message);
				});
			}
		}
		

		
		$scope.searchById = function(objidentifier, entitytype) {
			if(!$scope.groupIdDetails[objidentifier]) {
				$http.post('dedup/searchById.do', $.param({
					'entitytype' : entitytype,
					'objidentifier' : objidentifier
				})).success(function(res) {
		        	if(res) {
		    			$scope.groupIdDetails[objidentifier] = res;
		        		$scope.hideSpinner();
		        	} else {
		            	$scope.hideSpinner();
		        		$scope.showError('Registration failed');
		        	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Registration failed: ' + err.message);
				});			
			}
		}
		
		$scope.add = function(idCsv) {
			var size = $scope.group.group.length;
		    angular.forEach(idCsv.split(","), function(id) {
		    	if(jQuery.grep($scope.group.group, function(val, i) {
		    		  return val == id;
				}).length == 0) {
		        	$scope.group.group.push(id);
		    	} else {
		    		$scope.showError('id already selected');
		    	};
		    });	
		    var newSize = $scope.group.group.length - size;
		    if (newSize > 0) {
		    	$scope.showNotification('added ' + newSize + ' element(s)');
		    }
		}
		
		$scope.remove = function(idCsv) {
			var tmpGroup = [];
			var toRemove = idCsv.split(",");
			var size = $scope.group.group.length;
		    angular.forEach($scope.group.group, function(id) {
		    	if(jQuery.grep(toRemove, function(val, i) {
		    		  return val == id;
				}).length == 0) {
		        	tmpGroup.push(id);
		    	};
		    });
		    $scope.group.group = tmpGroup;
		    var newSize = size - tmpGroup.length;
		    if (newSize > 0) {
		    	$scope.showNotification('removed ' + newSize + ' element(s)');
		    }
		}	
		
		$scope.isSelected = function(idCsv) {
			var res = true;
			angular.forEach(idCsv.split(","), function(id) {
				if(jQuery.grep($scope.group.group, function(val, i) {
					  return val == id;
				}).length == 0) {
			    	res = false;
			    	return;
				};
			});
			return res;
		}
		
	}
]);

dedupInspectorControllers.controller('manageSimRelsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {

		common_init($scope, $http, $sce, $location);
		
		$scope.validEntityTypes = [ {id:'result' , name: 'Publications'}, {id:'organization' , name: 'Organizations'}, {id:'all', name:'All'} ];
		
		$scope.groups = [];
		
		if($routeParams.type) {
			$scope.type = $routeParams.type;
		} else {
			$scope.type = 'all';
		}
		if($routeParams.offset) {
			$scope.offset = parseInt($routeParams.offset);
		} else {
			$scope.offset = 0;
		}
		if($routeParams.limit) {
			$scope.limit = parseInt($routeParams.limit);
		} else {
			$scope.limit = 0;
		}
		
		$scope.refresh = function() {
			$scope.showSpinner();
			$http.get('dedup/listSimRels.do?entitytype=' + $scope.type + '&offset=' + $scope.offset + '&limit=' + $scope.limit).success(
				function(res) {
            		$scope.groups = res;
            		$scope.hideSpinner();
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Unable to list groups');
				});
		}
		$scope.showgroup = function(g) {
			$scope.go('/edit/' + g.id);
		}
		$scope.refresh();
	}
]);

dedupInspectorControllers.controller('editSimRelsCtrl', [
   	'$scope', '$http', '$sce', '$location', '$routeParams',
   	function ($scope, $http, $sce, $location, $routeParams) {

   		common_init($scope, $http, $sce, $location);
    		
   		$scope.group = {};
   		
   		$scope.refresh = function() {
   			$scope.showSpinner();
   			$http.get('dedup/getExtGroup.do?groupid=' + $routeParams.groupid).success(
   				function(res) {
               		$scope.group = res;
               		$scope.hideSpinner();
   				}).error(function(err) {
   					$scope.hideSpinner();
   					$scope.showError('Unable to get group');
   				});
   		}
   		$scope.editSimilarity = function(g) {
   			$scope.go('/add/' + g.id);
   		}

   		$scope.refresh();
   	}
]);


