CREATE TABLE IF NOT EXISTS fundingpaths (
	_dnet_resource_identifier_ character varying(2048) DEFAULT 'temp_'||md5(clock_timestamp()::text)||'_'||md5(random()::text),
	id                         character varying(512) PRIMARY KEY,
	path                       text NOT NULL,
	funder                     character varying(512) REFERENCES organizations(id),
	jurisdiction               character varying(16),
	optional1                  character varying(255),
	optional2                  character varying(255)
);

CREATE TABLE IF NOT EXISTS project_fundingpath (
	_dnet_resource_identifier_ character varying(2048) DEFAULT 'temp_'||md5(clock_timestamp()::text)||'_'||md5(random()::text),
	funding                    character varying(255) NOT NULL REFERENCES fundingpaths(id),
	project                    character varying(255) NOT NULL REFERENCES projects(id),
	startdate                  date,
	enddate                    date,
	semanticclass              character varying(255) REFERENCES class(code),
	semanticscheme             character varying(255) REFERENCES scheme(code),
	optional1                  character varying(255),
	optional2                  character varying(255),
	PRIMARY KEY (funding, project)
);

update datasources set namespaceprefix = 'wt__________' where id = 'openaire____::wellcometrust';
