package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FetchRelClassesJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchRelClassesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String relClassesProperty;

	private String relClassesName;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		String relClasses = new Gson().toJson(fetchRelClasses());

		log.info("loaded relClasses: " + relClasses);

		token.getEnv().setAttribute(getRelClassesName(), relClasses);

		return Arc.DEFAULT_ARC;
	}

	private List<String> fetchRelClasses() throws ISLookUpException {

		String xquery = getPropertyFetcher().getProperty(getRelClassesProperty());

		log.info("Loading relClasses with xquery: " + xquery);

		return serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
	}

	public String getRelClassesProperty() {
		return relClassesProperty;
	}

	public void setRelClassesProperty(final String relClassesProperty) {
		this.relClassesProperty = relClassesProperty;
	}

	public String getRelClassesName() {
		return relClassesName;
	}

	public void setRelClassesName(final String relClassesName) {
		this.relClassesName = relClassesName;
	}

}
