<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" >

	<xsl:output method="html" encoding="UTF-8" indent="no" 
		omit-xml-declaration="yes" standalone="no" />

	<xsl:param name="entitytype" />

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$entitytype = 'result'">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th>Group size</th><th>Title</th><th>Publication date</th><th>Authors</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="//*[local-name() = 'record']">
							<xsl:variable name="objidentifier">
								<xsl:choose>
									<xsl:when test="count(.//*[local-name()='children']/*[local-name()='result']/@objidentifier) &gt; 0">
										<xsl:value-of separator="," select=".//*[local-name()='children']/*[local-name()='result']/@objidentifier"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select=".//*[local-name()='objIdentifier']"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>							
							<tr ng-class="{{ success:isSelected('{$objidentifier}') }}">
								<td>
									<xsl:choose>
										<xsl:when test="count(.//*[local-name()='children']/*[local-name()='result']) &gt; 0">
											<xsl:value-of select="count(.//*[local-name()='children']/*[local-name()='result'])" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'1'" />
										</xsl:otherwise>
									</xsl:choose>									
								</td>	
								<td>
									<xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='result']/title[@classid='main title']" />
								</td>
								<td>
									<xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='result']/dateofacceptance" />
								</td>
								<td>
									<xsl:for-each select=".//*//rel[./to/@type='person']/fullname">
										<xsl:if test="position() &gt; 1">; </xsl:if>
										<xsl:value-of select="." />
									</xsl:for-each>
								</td>
								<td class="text-right">
									<button class="btn btn-primary btn-sm" ng-click="add('{$objidentifier}')" ng-hide="isSelected('{$objidentifier}')">
										<span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
									</button>
									<button class="btn btn-primary btn-sm btn-danger" ng-click="remove('{$objidentifier}')" ng-show="isSelected('{$objidentifier}')">
										<span class="glyphicon glyphicon-minus" aria-hidden="true"></span>
									</button>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:when>
			<xsl:when test="$entitytype = 'organization'">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th>Group size</th><th>Legal name</th><th>Legal short name</th><th>Website URL</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="//*[local-name() = 'record']">
							<xsl:variable name="objidentifier">
								<xsl:choose>
									<xsl:when test="count(.//*[local-name()='children']/*[local-name()='organization']/@objidentifier) &gt; 0">
										<xsl:value-of separator="," select=".//*[local-name()='children']/*[local-name()='organization']/@objidentifier"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select=".//*[local-name()='objIdentifier']"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>							
							<tr ng-class="{{ success:isSelected('{$objidentifier}') }}">
								<td>
									<xsl:choose>
										<xsl:when test="count(.//*[local-name()='children']/*[local-name()='organization']) &gt; 0">
											<xsl:value-of select="count(.//*[local-name()='children']/*[local-name()='organization'])" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="'1'" />
										</xsl:otherwise>
									</xsl:choose>									
								</td>							
								<td>
									<xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/legalname" />
								</td>
								<td>
									<xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/legalshortname" />
								</td>
								<td>
									<xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/websiteurl" />
								</td>
								<td class="text-right">
									<button class="btn btn-primary btn-sm" ng-click="add('{$objidentifier}')" ng-hide="isSelected('{$objidentifier}')">
										<span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
									</button>
									<button class="btn btn-primary btn-sm btn-danger" ng-click="remove('{$objidentifier}')" ng-show="isSelected('{$objidentifier}')">
										<span class="glyphicon glyphicon-minus" aria-hidden="true"></span>
									</button>
								</td>												
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>









