<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn">

	<xsl:template match="/">
		<fundings>
			<xsl:for-each select="//funding">
				<fundingtree>
					<funder>
						<id>arc_________::ARC</id>
						<shortname>ARC</shortname>
						<name>Australian Research Council (ARC)</name>
						<jurisdiction>AU</jurisdiction>
					</funder>
					<funding_level_1>
						<id><xsl:value-of select="concat('arc_________::ARC::', ./id)" /></id>
						<description><xsl:value-of select="./id" /></description>
						<name><xsl:value-of select="./name" /></name>
						<class>arc:fundingStream</class>
						<parent>
							<funding_level_0>
								<id>arc________::ARC</id>
								<description>Australian Research Council Funding Stream</description>
								<name>ARC</name>
								<parent></parent>
								<class>arc:fundingStream</class>
							</funding_level_0>
						</parent>
					</funding_level_1>
				</fundingtree>
			</xsl:for-each>
		</fundings>
	</xsl:template>
</xsl:stylesheet>
