package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import java.util.Map.Entry;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public abstract class AbstractHBaseAdminJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String tableColumnsParamName = "columns";
	private String hbaseTableProperty;
	private String cluster;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected void beforeStart(final NodeToken token) {
		for (Entry<String, String> e : parseJsonParameters(token).entrySet()) {
			token.getEnv().setAttribute(e.getKey(), e.getValue());
		}
	}

	protected String tableName(final NodeToken token) {
		if (token.getEnv().hasAttribute("hbaseTable")) {
			String table = token.getEnv().getAttribute("hbaseTable");
			log.debug("found override value in wfEnv for 'hbaseTable' param: " + table);
			return table;
		}
		return getPropertyFetcher().getProperty(getHbaseTableProperty());
	}

	protected String cluster(final NodeToken token) {
		if (token.getEnv().hasAttribute("cluster")) {
			String cluster = token.getEnv().getAttribute("cluster");
			log.debug("found override value in wfEnv for 'cluster' param: " + cluster);
			return cluster;
		}
		return getCluster();
	}

	protected Set<String> getColumns(final NodeToken token) throws MSROException {
		String envCols = token.getEnv().getAttribute(getTableColumnsParamName());
		if (StringUtils.isBlank(envCols)) { throw new MSROException("cannot find table description"); }
		log.debug("using columns from env: " + envCols);
		return Sets.newHashSet(Splitter.on(",").omitEmptyStrings().split(envCols));
	}

	protected String asCSV(final Iterable<String> columns) {
		return Joiner.on(",").skipNulls().join(columns);
	}

	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public String getHbaseTableProperty() {
		return hbaseTableProperty;
	}

	public void setHbaseTableProperty(final String hbaseTableProperty) {
		this.hbaseTableProperty = hbaseTableProperty;
	}

	public String getTableColumnsParamName() {
		return tableColumnsParamName;
	}

	public void setTableColumnsParamName(final String tableColumnsParamName) {
		this.tableColumnsParamName = tableColumnsParamName;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

}
