package eu.dnetlib.msro.openaireplus.workflows.nodes;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class CheckMDStoreCountsJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CheckMDStoreCountsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	// Info about the mdstores to include in the count
	private String format;
	private String layout;
	private String interpretation;

	/** Name of the env param where to find the number to check. **/
	private String numberToVerifyParamName;

	@Resource
	private UniqueServiceLocator serviceLocator;

	/**
	 * {@inheritDoc}
	 * 
	 * @throws MSROException
	 * 
	 * @see com.googlecode.sarasvati.mem.MemNode#execute(com.googlecode.sarasvati.Engine, com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	public String execute(final NodeToken token) throws MSROException {
		int mdstoreCount = 0;
		int numberToVerify = 0;
		String numberInEnvParam = WorkflowsConstants.BLACKBOARD_PARAM_PREFIX + numberToVerifyParamName;
		String valueString = token.getEnv().getAttribute(numberInEnvParam);
		try {
			mdstoreCount = serviceLocator.getService(MDStoreService.class).size(format, layout, interpretation);
			token.getEnv().setAttribute("mdstoreCount", mdstoreCount);
		} catch (Exception e) {
			log.error("Can't count total records in mdstores of type: " + format + "-" + layout + "-" + interpretation);
			throw new MSROException(e);
		}
		try {
			numberToVerify = Integer.parseInt(valueString);
		} catch (NumberFormatException e) {
			log.error("Env param name: " + numberInEnvParam + " is " + valueString + " and cannot be parsed as integer");
		}
		log.info("mdstore counts: " + mdstoreCount);
		log.info("number to verify: " + numberToVerify);
		if (mdstoreCount == numberToVerify) return Arc.DEFAULT_ARC;
		else throw new MSROException("Numbers are not the same. Number to verify: " + numberToVerify + ". From mdstore: " + mdstoreCount);

	}

	public String getFormat() {
		return format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getNumberToVerifyParamName() {
		return numberToVerifyParamName;
	}

	public void setNumberToVerifyParamName(final String numberToVerifyParamName) {
		this.numberToVerifyParamName = numberToVerifyParamName;
	}

}
