<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" >

	<xsl:output method="html" encoding="UTF-8" indent="no" 
		omit-xml-declaration="yes" standalone="no" />

	<xsl:param name="entitytype" />

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$entitytype = 'result'">
				<table class="table">
					<tr>
						<th class="col-xs-3">Title</th><td class="col-xs-9"><xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='result']/title[@classid='main title']" /></td>
					</tr>
					<tr>
						<th class="col-xs-3">Date</th><td class="col-xs-9"><xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='result']/dateofacceptance" /></td>
					</tr>
					<tr>			
						<th class="col-xs-3">Author(s)</th>
						<td class="col-xs-9">
							<xsl:for-each select=".//*//rel[./to/@type='person']/fullname">
								<xsl:if test="position() &gt; 1">; </xsl:if>
								<xsl:value-of select="." />
							</xsl:for-each>								
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="$entitytype = 'organization'">
				<table class="table">
					<tr>
						<th class="col-xs-3">Legal name</th><td class="col-xs-9"><xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/legalname" /></td>
					</tr>
					<tr>
						<th class="col-xs-3">Legal Short name</th><td class="col-xs-9"><xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/legalshortname" /></td>
					</tr>
					<tr>			
						<th class="col-xs-3">Website URL</th><td class="col-xs-9"><xsl:value-of select=".//*[local-name()='metadata']/*[local-name()='entity']/*[local-name()='organization']/websiteurl" /></td>
					</tr>
				</table>			
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>









