var dedupInspectorControllers = angular.module('dedupInspectorControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { document.location.href='#'+path; }
	$scope.encodeValue      = function(val)     { return val; }
	
	
	$scope.encodeDateParam = function(date) {
		var year = date.getFullYear();
		var month = ("00" + (date.getMonth() + 1)).slice(-2);
		var day = ("00" + date.getDate()).slice(-2);
		return year + month + day;
	}

	$scope.decodeDateParam = function(s) {
		var year = s.substring(0,4);
		var month = s.substring(4,6);
		var day = s.substring(6,8);

		return new Date(year,month-1,day);
	}
}

dedupInspectorControllers.controller('addSimRelsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {
	
		common_init($scope, $http, $sce, $location);
	
		$scope.validEntityTypes = [ {id:'50', type:'result', label:'Publication'}, {id:'20', type:'organization', label:'Organization'} ];
		
		$scope.entitytype = $routeParams.entitytype;
		$scope.tmpId = '';
		$scope.group = {
				group : []
		};		
	
		$scope.resetForm = function() {
			$scope.group = {
					group : []
			};	
			$scope.tmpId = '';
		}

		$scope.groupid = $routeParams.groupid;
		if($scope.groupid && $scope.groupid.length > 0) {
   			$scope.showSpinner();
   			$http.get('dedup/getSimpleGroup.do?groupid=' + $scope.groupid).success(
   				function(res) {
   					$scope.group = res;
               		$scope.hideSpinner();
   				}).error(function(err) {
   					$scope.hideSpinner();
   					$scope.showError('Unable to get group');
   				});
		}

		$scope.registerSimilarities = function() {
			if (confirm('Add new similarity group?')) {
				$scope.showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('dedup/addSimRels.do', $.param({
					'entityType' : $scope.group.entitytype.id,
					'idsCsv'  : $scope.group.group.join()
				})).success(function(res) {
	            	if(res) {
	            		$scope.showNotification('The Similarities has been registered');
	            		$scope.hideSpinner();
	            		$scope.resetForm();
	            	} else {
	                	$scope.hideSpinner();
	            		$scope.showError('Registration failed');
	            	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Registration failed: ' + err.message);
				});
			}
		}

		$scope.updateSimilarities = function() {
			if (confirm('Update similarity group?')) {
				$scope.showSpinner();
				$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
				$http.post('dedup/updateSimRels.do', $.param({
					'groupid' : $scope.group.id,
					'entityType' : $scope.group.entitytype.id,
					'idsCsv'  : $scope.group.group.join()
				})).success(function(res) {
	            	if(res) {
	            		$scope.showNotification('The Similarities has been updated');
	            		$scope.hideSpinner();
	            		$scope.resetForm();
	            		$scope.go('/edit/' + $scope.groupid);
	            	} else {
	                	$scope.hideSpinner();
	            		$scope.showError('Registration failed');
	            	}
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Registration failed: ' + err.message);
				});
			}
		}
		
		$scope.$watch('tmpId', function() {
			if ($scope.tmpId) {
				$scope.group.group.push($scope.tmpId);
				$scope.tmpId = '';
			}			
		});
	}
]);

dedupInspectorControllers.controller('manageSimRelsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {

		common_init($scope, $http, $sce, $location);
		
		$scope.validEntityTypes = [ {id:'result' , name: 'Publication'}, {id:'organization' , name: 'Organization'}, {id:'all', name:'All'} ];
		
		$scope.groups = [];
		
		$scope.type = $routeParams.type;
		$scope.offset = parseInt($routeParams.offset);
		$scope.limit = parseInt($routeParams.limit);
		
		$scope.refresh = function() {
			$scope.showSpinner();
			$http.get('dedup/listSimRels.do?entitytype=' + $scope.type + '&offset=' + $scope.offset + '&limit=' + $scope.limit).success(
				function(res) {
            		$scope.groups = res;
            		$scope.hideSpinner();
				}).error(function(err) {
					$scope.hideSpinner();
					$scope.showError('Unable to list groups');
				});
		}
		$scope.showgroup = function(g) {
			$scope.go('/edit/' + g.id);
		}
		$scope.refresh();
	}
]);

dedupInspectorControllers.controller('editSimRelsCtrl', [
   	'$scope', '$http', '$sce', '$location', '$routeParams',
   	function ($scope, $http, $sce, $location, $routeParams) {

   		common_init($scope, $http, $sce, $location);
    		
   		$scope.group = {};
   		
   		$scope.refresh = function() {
   			$scope.showSpinner();
   			$http.get('dedup/getExtGroup.do?groupid=' + $routeParams.groupid).success(
   				function(res) {
               		$scope.group = res;
               		$scope.hideSpinner();
   				}).error(function(err) {
   					$scope.hideSpinner();
   					$scope.showError('Unable to get group');
   				});
   		}
   		$scope.editSimilarity = function(g) {
   			$scope.go('/add/' + g.id);
   		}

   		$scope.refresh();
   	}
]);


