var module = angular.module('dedupInspector', ['ngRoute', 'dedupInspectorControllers']);

module.config([
	'$routeProvider',
	function($routeProvider) {
		$routeProvider
			.when('/add/:entitytype',	     		{ templateUrl: '../resources/html/dedup/add.html',      controller: 'addSimRelsCtrl' })
			.when('/add/:entitytype/:groupid',		{ templateUrl: '../resources/html/dedup/add.html',      controller: 'addSimRelsCtrl' })
			.when('/manage/:type/:offset/:limit', 	{ templateUrl: '../resources/html/dedup/manage.html',  	controller: 'manageSimRelsCtrl' })
			.when('/edit/:groupid',					{ templateUrl: '../resources/html/dedup/edit.html',  	controller: 'editSimRelsCtrl' })
			.otherwise({ redirectTo: '/manage/all/0/10' });
	}
]);

module.controller('moduleMenuCtrl', [ '$scope', '$location',  
	function ($scope, $location) {
		$scope.isActive = function(regex) {
			var re = new RegExp(regex);
			return re.test($location.path());
		}
	}
]);

module.directive('ngSimpleSelectField', function() {
	return {
		restrict: 'E',
		scope: {
            'label'           : '@',
            'validValues'     : '=',
            'selection'       : '='
		},
		templateUrl: '../resources/html/dedup/ngSimpleSelectField.html',
		link: function(scope, element, attrs) {
			scope.populateList = function() {
				scope.validValues = scope.functionList();
			}
		}
	}
});

module.directive('ngSimpleEditField', function() {
	return {
		restrict: 'E',
		scope: {
            'label'         : '@',
            'regex'         : '@',
            'optional'      : '@',
            'selection'     : '=',
		},
		templateUrl: '../resources/html/dedup/ngSimpleEditField.html',
		link: function(scope, element, attrs) {
			scope.required = (scope.optional != 'true');
			if      (scope.regex)             { scope.mypattern = new RegExp(scope.regex); }
			else                              { scope.mypattern = new RegExp(".+"); }
		}
	}
});

module.directive('ngFixedValueField', function() {
	return {
		restrict: 'E',
		scope: {
            'label'  : '@',
            'value'  : '='
		},
		templateUrl: '../resources/html/dedup/ngFixedValueField.html'
	}
});

module.directive('bsHasError', function() {
	return {
		restrict: "A",
		link: function(scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model]');
			if (input) {
				scope.$watch(function() {
					if (input.hasClass('ng-invalid')) {
						return 0;
					} else if (input.hasClass('empty')) {
						return 1;
					} else {
						return 2;
					}
				}, function(code) {
					if (code < 0) return;
					
					element.toggleClass('has-error', (code == 0));
					element.toggleClass('has-warning', (code == 1));
					element.toggleClass('has-success', (code == 2));
					
					var feedback = element.find('.form-control-feedback');
					if (feedback) {
						feedback.toggleClass('glyphicon-remove', (code == 0));
						feedback.toggleClass('glyphicon-warning-sign', (code == 1));
						feedback.toggleClass('glyphicon-ok', (code == 2));
					}
				});
			}
		}
	};
});

module.directive('compileTemplate', function($compile, $parse){
    return {
        link: function(scope, element, attr){
            var parsed = $parse(attr.ngBindHtml);

            function getStringValue() { return (parsed(scope) || '').toString(); }

            //Recompile if the template changes
            scope.$watch(getStringValue, function() {
            	$compile(element, null, -9999)(scope);  //The -9999 makes it skip directives so that we do not recompile ourselves
            });
        }
    }
});

