<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:fn="http://www.w3.org/2005/xpath-functions" >

	<xsl:output method="html" encoding="UTF-8" indent="no" 
		omit-xml-declaration="yes" standalone="no" />

	<xsl:param name="entitytype" />

	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$entitytype = 'result'">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th>Title</th><th>Publication date</th><th>Authors</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="//*[local-name() = 'entity']">
							<tr>
								<td>
									<xsl:value-of select="./*[local-name() ='result']/title | ./*[local-name()='result']/children/result/title" />
								</td>
								<td>
									<xsl:value-of select="./*[local-name()='result']/dateofacceptance" />
								</td>
								<td>
									<xsl:for-each select="./*//rel[./to/@type='person']/fullname">
										<xsl:if test="position() &gt; 1">; </xsl:if>
										<xsl:value-of select="." />
									</xsl:for-each>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:when>
			<xsl:when test="$entitytype = 'organization'">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th>Legal name</th><th>legal short name</th><th>website</th>
						</tr>
					</thead>
					<tbody>
						<xsl:for-each select="//*[local-name() = 'entity']">			
							<tr>
								<td>
									<xsl:value-of select="./*[local-name()='organization']/legalname" />
								</td>
								<td>
									<xsl:value-of select="./*[local-name()='organization']/legalshortname" />
								</td>
								<td>
									<xsl:value-of select="./*[local-name()='organization']/websiteurl" />
								</td>					
							</tr>
						</xsl:for-each>
					</tbody>
				</table>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>









