/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.hbase;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class StoreHBaseRecordsJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(StoreHBaseRecordsJobNode.class);
    private String inputEprParam;
    private String hbaseTableProperty;
    private String cluster;
    private String xslt;
    private boolean simulation = false;
    private ProgressProvider progressProvider;
    private ProcessCountingResultSetFactory processCountingResultSetFactory;

    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        log.info((Object)"Invoking blackboard method");
        job.setAction(HadoopBlackboardActions.IMPORT_EPR_HBASE.toString());
        job.getParameters().put("input_epr", DnetXsltFunctions.encodeBase64((String)this.prepareEpr(token)));
        job.getParameters().put("xslt", DnetXsltFunctions.encodeBase64((String)this.prepareXslt()));
        job.getParameters().put("table", this.getPropertyFetcher().getProperty(this.getHbaseTableProperty()));
        job.getParameters().put("cluster", this.cluster);
        job.getParameters().put("simulation", String.valueOf(this.isSimulation()));
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:" + StoreHBaseRecordsJobNode.this.getName() + ":count", responseParams.get("count"));
            }
        };
    }

    private String prepareEpr(NodeToken token) throws ResultSetException {
        String epr = token.getEnv().getAttribute(this.inputEprParam);
        ResultsetProgressProvider resultsetProgressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), epr);
        this.setProgressProvider((ProgressProvider)resultsetProgressProvider);
        return resultsetProgressProvider.getEpr().toString();
    }

    private String prepareXslt() throws IOException {
        return this.xslt == null || this.xslt.isEmpty() ? "" : IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.xslt));
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getHbaseTableProperty() {
        return this.hbaseTableProperty;
    }

    public void setHbaseTableProperty(String hbaseTableProperty) {
        this.hbaseTableProperty = hbaseTableProperty;
    }

    @Required
    public void setProcessCountingResultSetFactory(ProcessCountingResultSetFactory processCountingResultSetFactory) {
        this.processCountingResultSetFactory = processCountingResultSetFactory;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }

    public ProcessCountingResultSetFactory getProcessCountingResultSetFactory() {
        return this.processCountingResultSetFactory;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }
}

