/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dedup;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityMeshBuilder;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class BuildSimilarityMeshJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(BuildSimilarityMeshJobNode.class);
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    @Resource(name="resultSetClientFactory")
    private ResultSetClientFactory resultSetClientFactory;
    private StringTemplate similarity;
    private String inputEprParam;
    private String outputEprParam;

    protected String execute(NodeToken token) throws Exception {
        String inputEpr = token.getEnv().getAttribute(this.getInputEprParam());
        final Iterator rsClient = this.resultSetClientFactory.getClient(inputEpr).iterator();
        final LinkedBlockingQueue queue = Queues.newLinkedBlockingQueue();
        final SAXReader reader = new SAXReader();
        if (rsClient.hasNext()) {
            this.populateQueue(queue, reader, (String)rsClient.next());
        }
        W3CEndpointReference eprOut = this.resultSetFactory.createIterableResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        Queue queue = queue;
                        synchronized (queue) {
                            return !queue.isEmpty();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String next() {
                        Queue queue = queue;
                        synchronized (queue) {
                            Object o = queue.poll();
                            while (queue.isEmpty() && rsClient.hasNext()) {
                                BuildSimilarityMeshJobNode.this.populateQueue(queue, reader, (String)rsClient.next());
                            }
                            return BuildSimilarityMeshJobNode.this.buildSimilarity((Pair<String, String>)((Pair)o));
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        token.getEnv().setAttribute(this.getOutputEprParam(), eprOut.toString());
        return Arc.DEFAULT_ARC;
    }

    private void populateQueue(Queue<Object> q, SAXReader r, String xml) {
        try {
            Document d = r.read((Reader)new StringReader(xml));
            String groupid = d.valueOf("//FIELD[@name='id']");
            List items = d.selectNodes("//FIELD[@name='group']/ITEM");
            String entitytype = d.valueOf("//FIELD[@name='entitytype']");
            ArrayList group = Lists.newArrayList();
            for (Object id : items) {
                group.add(((Node)id).getText());
            }
            String type = String.valueOf(TypeProtos.Type.valueOf((String)entitytype).getNumber());
            List<Pair<String, String>> mesh = SimilarityMeshBuilder.build(type, group);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("built mesh for group '%s', size %d", groupid, mesh.size()));
            }
            for (Pair<String, String> p : mesh) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("adding to queue: %s", p.toString()));
                }
                q.add(p);
            }
        }
        catch (DocumentException e) {
            log.error((Object)("invalid document: " + xml));
        }
    }

    private String buildSimilarity(Pair<String, String> p) {
        StringTemplate template = new StringTemplate(this.getSimilarity().getTemplate());
        template.setAttribute("source", p.getKey());
        template.setAttribute("target", p.getValue());
        String res = template.toString();
        return res;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public StringTemplate getSimilarity() {
        return this.similarity;
    }

    @Required
    public void setSimilarity(StringTemplate similarity) {
        this.similarity = similarity;
    }
}

