/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.values;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListHBaseTables
extends ValidNodeValuesFetcher {
    private static final Log log = LogFactory.getLog(ListHBaseTables.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private Function<String, ValidNodeValuesFetcher.DnetParamValue> f = new Function<String, ValidNodeValuesFetcher.DnetParamValue>(){

        public ValidNodeValuesFetcher.DnetParamValue apply(String s) {
            return new ValidNodeValuesFetcher.DnetParamValue((ValidNodeValuesFetcher)ListHBaseTables.this, s, s);
        }
    };

    protected List<ValidNodeValuesFetcher.DnetParamValue> obtainValues(Map<String, String> params) throws Exception {
        ArrayList res = Lists.newArrayList((Iterable)Iterables.transform(this.listTables(params.get("cluster")), this.f));
        return res;
    }

    private List<String> listTables(String cluster) {
        try {
            log.info((Object)("list tables for cluster: " + cluster));
            return ((HadoopService)this.serviceLocator.getService(HadoopService.class)).listHbaseTables(cluster);
        }
        catch (Throwable e) {
            log.error((Object)e);
            return Lists.newArrayList();
        }
    }
}

