/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.dedup;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.functionality.index.client.response.LookupResponse;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.dedup.ExtendendSimilarityGroup;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroupFunction;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DedupServiceInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(DedupServiceInternalController.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    @Value(value="${dnet.openaire.db.name}")
    private String dbName;
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    @Value(value="${dnet.openaire.similaritygroups.index.format.xquery}")
    private String indexFormatXquery;
    @Value(value="${dnet.openaire.similaritygroups.indexrecord2html.xsl}")
    private org.springframework.core.io.Resource recordToHtmlXsl;
    private String currentIndex = "";
    private IndexClient indexClient = null;

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/listSimRels.do"})
    public List<SimilarityGroup> list(@RequestParam(value="entitytype", required=true) String entitytype, @RequestParam(value="offset", required=true) String offset, @RequestParam(value="limit", required=true) String limit) throws Exception {
        StringBuilder query = new StringBuilder("SELECT groupid as id, entitytype, date, array_agg(objidentifier) as group FROM similarity_groups sg LEFT OUTER join similarities s ON (s.groupid = sg.id) ");
        if (!entitytype.equals("all")) {
            query.append("WHERE entitytype = '" + entitytype + "' ");
        }
        query.append("GROUP BY groupid, entitytype, date OFFSET %s LIMIT %s");
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.dbName, String.format(query.toString(), offset, limit));
        ArrayList res = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.resultSetClientFactory.getClient(epr), (Function)new SimilarityGroupFunction()));
        log.info((Object)String.format("found %d similarity entries", res.size()));
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/getExtGroup.do"})
    public ExtendendSimilarityGroup getExtendedGroup(@RequestParam(value="groupid", required=true) String groupid) throws Exception {
        SimilarityGroup group = this.getSimpleGroup(groupid);
        String cqlQuery = Joiner.on((String)" or ").join(Iterables.transform(group.getGroup(), (Function)new Function<String, String>(){

            public String apply(String id) {
                return "objidentifier exact \"" + id + "\"";
            }
        }));
        ApplyXslt recordToHtmlTable = new ApplyXslt(this.recordToHtmlXsl, this.getXslParams(group));
        String format = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(this.indexFormatXquery);
        LookupResponse indexRsp = this.getIndexClient(format).lookup(cqlQuery, null, 0, group.getGroup().size());
        log.debug((Object)String.format("found %d index records among %d similar, index %s", indexRsp.getRecords().size(), group.getGroup().size(), format));
        return new ExtendendSimilarityGroup(group, recordToHtmlTable.evaluate((Object)("<records>" + Joiner.on((String)"").join((Iterable)indexRsp.getRecords()) + "</records>")));
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/getSimpleGroup.do"})
    public SimilarityGroup getSimpleGroup(@RequestParam(value="groupid", required=true) String groupid) throws Exception {
        String sqlQuery = String.format("SELECT groupid as id, entitytype, date, array_agg(objidentifier) as group FROM similarity_groups sg LEFT OUTER join similarities s ON (s.groupid = sg.id) WHERE groupid = '%s' GROUP BY groupid, entitytype, date", groupid);
        W3CEndpointReference epr = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.dbName, sqlQuery);
        SimilarityGroup group = (SimilarityGroup)Iterables.getOnlyElement((Iterable)Iterables.transform((Iterable)this.resultSetClientFactory.getClient(epr), (Function)new SimilarityGroupFunction()));
        log.debug((Object)String.format("found %s similarity group, size %d", group.getId(), group.getGroup().size()));
        return group;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/addSimRels.do"})
    public boolean add(@RequestParam(value="entityType", required=true) String entityType, @RequestParam(value="idsCsv", required=true) String idsCsv) throws Exception {
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        String groupid = UUID.randomUUID().toString();
        String date = DateUtils.now_ISO8601();
        StringBuilder sql = new StringBuilder(String.format("BEGIN; INSERT INTO similarity_groups(id, date, entitytype) VALUES('%s', '%s', '%s');", groupid, date, TypeProtos.Type.valueOf((int)Integer.valueOf(entityType))));
        for (String id : this.toSqlArraySet(entityType, idsCsv)) {
            if (dbService.contains(this.dbName, "similarities", "objidentifier", id)) {
                throw new Exception("id already defined in a similarity group.");
            }
            sql.append(String.format("INSERT INTO similarities(groupid, objidentifier) VALUES('%s', '%s'); ", groupid, id));
        }
        sql.append("COMMIT;");
        log.info((Object)("adding similarities: " + idsCsv));
        return dbService.updateSQL(this.dbName, sql.toString());
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/updateSimRels.do"})
    public boolean update(@RequestParam(value="entityType", required=true) String entityType, @RequestParam(value="groupid", required=true) String groupid, @RequestParam(value="idsCsv", required=true) String idsCsv) throws Exception {
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        String date = DateUtils.now_ISO8601();
        StringBuilder sql = new StringBuilder(String.format("BEGIN; UPDATE similarity_groups SET date = '%s', entitytype = '%s' WHERE id = '%s'; ", date, TypeProtos.Type.valueOf((int)Integer.valueOf(entityType)), groupid));
        for (String id : this.toSqlArraySet(entityType, idsCsv)) {
            if (dbService.contains(this.dbName, "similarities", "objidentifier", id)) continue;
            sql.append(String.format("INSERT INTO similarities(groupid, objidentifier) VALUES('%s', '%s'); ", groupid, id));
        }
        sql.append("COMMIT;");
        return dbService.updateSQL(this.dbName, sql.toString());
    }

    private IndexClient getIndexClient(String format) throws IndexClientException {
        if (!this.currentIndex.equals(format)) {
            this.currentIndex = format;
            this.indexClient = this.indexClientFactory.getClient(this.currentIndex, "index", "openaire", "solr");
        }
        return this.indexClient;
    }

    private Map<String, String> getXslParams(SimilarityGroup group) {
        HashMap xslParam = Maps.newHashMap();
        xslParam.put("entitytype", group.getEntitytype().getType());
        return xslParam;
    }

    private Set<String> toSqlArraySet(String entityType, String idsCsv) throws Exception {
        Iterable split = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)idsCsv.replaceAll("'", ""));
        if (Iterables.size((Iterable)split) < 2) {
            throw new Exception("id list must containt at least 2 entries");
        }
        return Sets.newLinkedHashSet((Iterable)split);
    }
}

