/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.dedup;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DedupConfigurationLoaderJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(DedupConfigurationLoaderJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private StringTemplate xqueryPace;
    private StringTemplate xqueryWf;
    private String entityType;

    protected String execute(NodeToken token) throws Exception {
        if (this.getEntityType() == null || this.getEntityType().isEmpty()) {
            throw new IllegalArgumentException("missing entity type parameter");
        }
        token.getEnv().setAttribute("entityType", this.getEntityType());
        token.getEnv().setAttribute("dedup.pace.conf", this.loadPaceConf(this.getEntityType()));
        token.getEnv().setAttribute("dedup.wf.conf", this.loadWfConf(this.getEntityType()));
        return Arc.DEFAULT_ARC;
    }

    public String loadPaceConf(String entityType) throws ISLookUpException {
        return this.loadConfig(this.getXquery(entityType, this.getXqueryPace()));
    }

    public String loadWfConf(String entityType) throws ISLookUpException {
        return this.loadConfig(this.getXquery(entityType, this.getXqueryWf()));
    }

    private String loadConfig(String xquery) throws ISLookUpException {
        log.info((Object)("loading configuration: " + xquery));
        List profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        if (profile == null || profile.isEmpty()) {
            throw new IllegalStateException("unable to load dedup configuration profile");
        }
        String conf = (String)Iterables.getOnlyElement((Iterable)profile);
        return conf.replaceAll("\\s+", " ").trim();
    }

    private String getXquery(String entityType, StringTemplate template) {
        StringTemplate xquery = new StringTemplate(template.getTemplate());
        xquery.setAttribute("entityType", (Object)entityType);
        return xquery.toString();
    }

    public StringTemplate getXqueryPace() {
        return this.xqueryPace;
    }

    @Required
    public void setXqueryPace(StringTemplate xqueryPace) {
        this.xqueryPace = xqueryPace;
    }

    public StringTemplate getXqueryWf() {
        return this.xqueryWf;
    }

    @Required
    public void setXqueryWf(StringTemplate xqueryWf) {
        this.xqueryWf = xqueryWf;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }
}

