/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes;

import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchRelClassesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchRelClassesJobNode.class);
    private String relClassesProperty;
    private String relClassesName;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        String relClasses = new Gson().toJson(this.fetchRelClasses());
        log.info((Object)("loaded relClasses: " + relClasses));
        token.getEnv().setAttribute(this.getRelClassesName(), relClasses);
        return Arc.DEFAULT_ARC;
    }

    private List<String> fetchRelClasses() throws ISLookUpException {
        String xquery = this.getPropertyFetcher().getProperty(this.getRelClassesProperty());
        log.info((Object)("Loading relClasses with xquery: " + xquery));
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
    }

    public String getRelClassesProperty() {
        return this.relClassesProperty;
    }

    public void setRelClassesProperty(String relClassesProperty) {
        this.relClassesProperty = relClassesProperty;
    }

    public String getRelClassesName() {
        return this.relClassesName;
    }

    public void setRelClassesName(String relClassesName) {
        this.relClassesName = relClassesName;
    }
}

