/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.stats;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.stats.StatsProcessEntry;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class StatsServiceInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(StatsServiceInternalController.class);
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    @Value(value="${dnet.openaire.stats.validation.wftype}")
    private String statsWfType;
    @Value(value="${dnet.openaire.stats.validation.logparam}")
    private String reportLogParam;
    @Value(value="${dnet.openaire.stats.validation.fields}")
    private String validationFields;

    private Map<String, String> getReportQuery() {
        HashMap query = Maps.newHashMap();
        query.put("system:profileFamily", this.statsWfType);
        query.put("system:isCompletedSuccessfully", "true");
        query.put("$exists", this.reportLogParam);
        return query;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/stats/list.do"})
    public List<StatsProcessEntry> list(@RequestParam(value="start", required=true) String start, @RequestParam(value="end", required=true) String end) throws Exception {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTime startDate = formatter.parseDateTime(start);
        DateTime endDate = formatter.parseDateTime(end).plusHours(23).plusMinutes(59).plusSeconds(59);
        Map<String, String> query = this.getReportQuery();
        ArrayList res = Lists.newArrayList((Iterator)Iterators.transform((Iterator)this.dnetLogger.range(startDate.toDate(), endDate.toDate(), query), (Function)new JournalEntryFunction()));
        log.info((Object)String.format("found %d stat validation workflows", res.size()));
        Collections.sort(res);
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/stats/getReport.do"})
    public List<Pair<String, Integer>> getReport(@RequestParam(value="procid", required=true) String procid) throws Exception {
        ArrayList res = Lists.newArrayList();
        Map logEntry = this.dnetLogger.findOne("system:processId", procid);
        if (!logEntry.containsKey(this.reportLogParam)) {
            log.warn((Object)String.format("unable to find report for procId '%s'", procid));
        } else {
            Document report = new SAXReader().read((Reader)new StringReader((String)logEntry.get(this.reportLogParam)));
            for (Object o : report.selectNodes("//queries")) {
                String name = ((Element)o).selectSingleNode("./name").getText().trim();
                int count = Integer.parseInt(((Element)o).selectSingleNode("./dbResult").getText().trim());
                res.add(new Pair((Object)name, (Object)count));
            }
        }
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/stats/listHistoryFields.do"})
    public String listLegendFields() throws Exception {
        return this.validationFields;
    }

    @ResponseBody
    @RequestMapping(value={"/ui/stats/history.do"})
    public List<Map<String, Object>> getHistory(@RequestParam(value="fieldsJson", required=true) String fieldsJson) throws Exception {
        List fields = (List)new Gson().fromJson(fieldsJson, new TypeToken<List<String>>(){}.getType());
        Map<String, String> query = this.getReportQuery();
        ArrayList res = Lists.newArrayList((Iterator)Iterators.transform((Iterator)this.dnetLogger.find(query), (Function)new JournalGraphEntryFunction(this.reportLogParam, fields)));
        log.info((Object)String.format("found %d stat validation workflows", res.size()));
        if (log.isDebugEnabled()) {
            for (Map m : res) {
                for (Map.Entry e : m.entrySet()) {
                    log.debug((Object)((String)e.getKey() + " -> " + e.getValue()));
                }
            }
        }
        return res;
    }

    private class JournalGraphEntryFunction
    implements Function<Map<String, String>, Map<String, Object>> {
        private String reportLogParam;
        private Map<String, String> fields;
        private final SAXReader reader = new SAXReader();
        private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public JournalGraphEntryFunction(String reportLogParam, List<String> list) {
            this.fields = Maps.newHashMap();
            this.reportLogParam = reportLogParam;
            for (String f : list) {
                this.fields.put(f.replaceAll("\\s", "").toLowerCase(), f);
            }
        }

        public Map<String, Object> apply(Map<String, String> input) {
            String report = input.get(this.reportLogParam);
            HashMap map = Maps.newHashMap();
            map.put("date", this.formatter.format(NumberUtils.toLong((String)input.get("log:date"), (long)0L)));
            try {
                Document doc = this.reader.read((Reader)new StringReader(report));
                for (Object o : doc.selectNodes("//queries")) {
                    String k = ((Element)o).valueOf("./name").replaceAll("\\s", "").toLowerCase();
                    String v = ((Element)o).valueOf("./dbResult").trim();
                    if (!this.fields.containsKey(k)) continue;
                    map.put(this.fields.get(k), NumberUtils.toInt((String)v, (int)0));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Error parsing report: " + report), (Throwable)e);
            }
            return map;
        }
    }

    private final class JournalEntryFunction
    implements Function<Map<String, String>, StatsProcessEntry> {
        private JournalEntryFunction() {
        }

        public StatsProcessEntry apply(Map<String, String> input) {
            String procId = input.get("system:processId");
            long date = NumberUtils.toLong((String)input.get("log:date"), (long)0L);
            return new StatsProcessEntry(procId, date);
        }
    }
}

