var statInspectorControllers = angular.module('statInspectorControllers', []);

function common_init($scope, $http, $sce, $location) {
	initSpinner();
	$scope.showError        = function(error)   { show_notification("error", error); }
	$scope.showNotification = function(message) { show_notification("info", message); }
	$scope.showSpinner      = function()        { showSpinner(); }
	$scope.hideSpinner      = function()        { hideSpinner(); }
	$scope.to_trusted       = function(html)    { return $sce.trustAsHtml(html); }
	$scope.go               = function(path)    { document.location.href='#'+path; }
	$scope.encodeValue      = function(val)     { return val; }
	
	
	$scope.encodeDateParam = function(date) {
		var year = date.getFullYear();
		var month = ("00" + (date.getMonth() + 1)).slice(-2);
		var day = ("00" + date.getDate()).slice(-2);
		return year + month + day;
	}

	$scope.decodeDateParam = function(s) {
		var year = s.substring(0,4);
		var month = s.substring(4,6);
		var day = s.substring(6,8);

		return new Date(year,month-1,day);
	}
}

statInspectorControllers.controller('listStatsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {
		
		common_init($scope, $http, $sce, $location);

		$scope.showSpinner();

		$scope.startDate = $scope.decodeDateParam($routeParams.from);
		$scope.endDate = $scope.decodeDateParam($routeParams.to);
		$scope.procId = $routeParams.procid;
					
		$scope.journal = [];
		$scope.report = "";

		$scope.update = function(start, end, procid) {
			$scope.go('/list/' + $scope.encodeDateParam(start) + '/' + $scope.encodeDateParam(end) + '/' + procid);
		}

		$scope.updateDates = function(start, end) {
			$scope.update(start, end, 'x');
		}

		$scope.formatDate = function(date) {
			var year = date.getFullYear();
			var month = ("00" + (date.getMonth() + 1)).slice(-2);
			var day = ("00" + date.getDate()).slice(-2);
			return year + '-' + month + '-' + day;
		}
		
        $scope.sort = {
            column: '',
            descending: false
        };    
        $scope.changeSorting = function(column) {
            var sort = $scope.sort;
            if (sort.column == column) {
                sort.descending = !sort.descending;
            } else {
                sort.column = column;
                sort.descending = false;
            }
        };
		
		$http.get('stats/list.do?start=' + $scope.formatDate($scope.startDate) + '&end=' + $scope.formatDate($scope.endDate)).success(
			function(data) {
				$scope.journal = data;
				$scope.hideSpinner();
			}
		).error(
			function() {
				$scope.showError('Error listing stat reports');
				$scope.hideSpinner();
			}
		);
		
		if($scope.procId != "x") {
			$http.get('stats/getReport.do?procid=' + $scope.procId).success(
				function(data) {
					$scope.report = data;
					$scope.hideSpinner();
				}
			).error(
				function() {
					$scope.showError('Error getting stat report');
					$scope.hideSpinner();
				}
			);
		}
		
	}
	
]);

statInspectorControllers.controller('historyStatsCtrl', [
	'$scope', '$http', '$sce', '$location', '$routeParams',
	function ($scope, $http, $sce, $location, $routeParams) {
		common_init($scope, $http, $sce, $location);
		
		$scope.availableFields = [];
		$scope.fields = [ '' ];
		$scope.data = [ { 'date' : '2014-01-01 20:00:00' } ];
		
		$scope.showSpinner();
		$http.get('stats/listHistoryFields.do').success(
			function(data) {
				$scope.availableFields = [];
				angular.forEach(data, function(value, key) {
					$scope.availableFields.push({
						'name'     : value,
						'selected' : false
					});
				});
				$scope.hideSpinner();
			}
		).error(
			function() {
				$scope.showError('Error getting history fields');
				$scope.hideSpinner();
			}
		);
		
		$scope.redrawGraph = function() {
			$('#historyGraph').empty();
			Morris.Line({
				resize    : true,
                element   : 'historyGraph',
                data      : $scope.data,
                xkey      : 'date',
                parseTime : true,
                ykeys     : $scope.fields,
                labels    : $scope.fields
            })
		}
		
		
		$scope.updateGraph = function() {
			$scope.fields = [];
			angular.forEach($scope.availableFields, function(f, key) {
				if (f.selected) {
					$scope.fields.push(f.name);
				}
			});
			
			$http.defaults.headers.post["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
			$http.post('stats/history.do', $.param({
				'fieldsJson' : JSON.stringify($scope.fields)
			})).success(
				function(data) {
					$scope.data = data;
					$scope.redrawGraph();
					$scope.hideSpinner();
				}
			).error(
				function() {
					$scope.showError('Error getting history fields');
					$scope.hideSpinner();
				}
			);
		};
		
		$scope.redrawGraph();
	}
]);


